% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Estimation_TAAG.R
\name{TAAG}
\alias{TAAG}
\title{Transformed Approximately Additive Gaussian Process}
\usage{
TAAG(parTAG, nu.est, adj.nu = FALSE)
}
\arguments{

\item{parTAG}{object of class inheriting from "TAG".}

\item{nu.est}{the estimates of the length scale parameters from a standard GP.}

\item{adj.nu}{logical. If FALSE, the proportional parameter \eqn{\eta} is estimated; otherwise, both \eqn{\eta} and the multiplication factor \eqn{\phi} are estimated. Default is FALSE.}
}
\description{
This function fits the Transformed Approximately Additive Gaussian (TAAG) process.
}
\details{
The details of TAAG process can be found in Lin and Joseph (2019).

When the input dimension is high, set adj.nu = TRUE and nu.est = s0, where s0 is the initial values of the length scale parameters from the function initial.TAG. Then, the length scale parameter  \eqn{\nu} is set to  \eqn{\phi \times} s0, and \eqn{\phi} is estimated through function TAAG.. This is useful especially when the input dimension is high.
}
\value{
The values returned from the function is a list containing the following components:
\item{omega}{The estimates of the weight parameters.}
\item{s}{The estimates of the length scale parameters.}
\item{nu}{The estimates of the length scale parameter \eqn{\nu}.}
\item{lambda}{The estimate of the Box-Cox transformation parameter.}
\item{eta}{The estimate of the proportion parameter.}
\item{phi}{The estimate of the multiplication factor for \eqn{\nu}, used for high dimensional data.}
\item{obj.fun}{The negative of log-unnormalized posterior value (value of the objective function)}
\item{ty}{The transformed response vector.}
\item{X}{The n by p input design matrix.}
}
\references{
Lin, L.-H. and Joseph,  V. R. (2020) "Transformation and Additivity in Gaussian Processes",\emph{Technometrics}, 62, 525-535.  DOI:10.1080/00401706.2019.1665592.
}
\seealso{
 \code{\link{TAG}} for the estimates of the TAG parameters, and \code{\link{pred.TAAG}} for predictions.
}
\examples{
n <- 20
p <- 2
library(randtoolbox)
X <-  sobol(n, dim = p, init = TRUE, scrambling = 2, seed = 20, normal = FALSE)
y <- exp(2*sin(0.5*pi*X[,1]) + 0.5*cos(2.5*pi*X[,2]))
ini.TAG <- initial.TAG(y, X)
par.TAG <- TAG(ini.TAG)
N <- 1000
X.test <- sobol(N, dim = p, init = TRUE, scrambling = 2, seed = 5, normal = FALSE)
ytrue  <- exp(2*sin(0.5*pi*X.test[,1]) + 0.5*cos(2.5*pi*X.test[,2]))
pre.TAG <- pred.TAG(par.TAG, X.test)
library(DiceKriging)
set.seed(2)
temp.m <- km(formula=~1, design=X, response=par.TAG$ty,
             covtype="gauss",nugget = (10^-15), multistart = 4,
             control = list(trace = FALSE, verbose = FALSE))
nu.est <- sqrt(2*(coef(temp.m)$range^2))
par.TAAG <- TAAG(par.TAG, nu.est)
}
\keyword{Estimated Parameters}
\keyword{TAAG}
