% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clean.data.R
\name{clean.data}
\alias{clean.data}
\title{Clean Data}
\usage{
clean.data(folder = "bootstrap/data", quiet = FALSE, force = FALSE)
}
\arguments{
\item{folder}{location of \verb{bootstrap/data}.}

\item{quiet}{whether to suppress messages about removed data.}

\item{force}{whether to remove \verb{folder}, regardless of how it compares
to \verb{DATA.bib} entries.}
}
\value{
No return value, called for side effects.
}
\description{
Selectively remove data from the \verb{bootstrap/data} folder if not listed
in \verb{DATA.bib}.
}
\note{
For each data file or subfolder, the cleaning procedure selects between two
cases:
\enumerate{
\item Data entry found in \verb{DATA.bib} - do nothing.
\item Data entry is not listed in \verb{DATA.bib} - remove.
}

The \code{taf.bootstrap} procedure cleans the \verb{bootstrap/data} folder,
without requiring the user to run \code{clean.data}.
}
\examples{
\dontrun{
clean.data()
}

}
\seealso{
\code{\link{taf.bootstrap}} calls \code{clean.data} as part of the default
bootstrap procedure.

\code{\link{clean.software}} cleans the local TAF software folder.

\code{\link{clean.library}} cleans the local TAF library.

\code{\link{TAF-package}} gives an overview of the package.
}
