% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/algorithm_sc12L.R
\name{sc12L}
\alias{sc12L}
\title{Spectral Clustering by Li and Guo (2012)}
\usage{
sc12L(data, k = 2, sigma = 1, ...)
}
\arguments{
\item{data}{an \eqn{(n\times p)} matrix of row-stacked observations or S3 \code{dist} object of \eqn{n} observations.}

\item{k}{the number of clusters (default: 2).}

\item{sigma}{common bandwidth parameter (default: 1).}

\item{...}{extra parameters including \describe{
\item{algclust}{method to perform clustering on embedded data; either \code{"kmeans"} (default) or \code{"GMM"}.}
\item{maxiter}{the maximum number of iterations (default: 10).}
}}
}
\value{
a named list of S3 class \code{T4cluster} containing 
\describe{
\item{cluster}{a length-\eqn{n} vector of class labels (from \eqn{1:k}).} 
\item{eigval}{eigenvalues of the graph laplacian's spectral decomposition.}
\item{embeds}{an \eqn{(n\times k)} low-dimensional embedding.}
\item{algorithm}{name of the algorithm.}
}
}
\description{
Li and Guo proposed to construct an affinity matrix
\deqn{A_{ij} = \exp(-d(x_i, d_j)^2 / 2 \sigma^2)} and adjust the matrix 
by neighbor propagation. Then, standard spectral clustering from 
the symmetric, normalized graph laplacian is applied.
}
\examples{
# -------------------------------------------------------------
#            clustering with 'iris' dataset
# -------------------------------------------------------------
## PREPARE
data(iris)
X   = as.matrix(iris[,1:4])
lab = as.integer(as.factor(iris[,5]))

## EMBEDDING WITH PCA
X2d = Rdimtools::do.pca(X, ndim=2)$Y

## CLUSTERING WITH DIFFERENT K VALUES
cl2 = sc12L(X, k=2)$cluster
cl3 = sc12L(X, k=3)$cluster
cl4 = sc12L(X, k=4)$cluster

## VISUALIZATION
opar <- par(no.readonly=TRUE)
par(mfrow=c(1,4), pty="s")
plot(X2d, col=lab, pch=19, main="true label")
plot(X2d, col=cl2, pch=19, main="sc12L: k=2")
plot(X2d, col=cl3, pch=19, main="sc12L: k=3")
plot(X2d, col=cl4, pch=19, main="sc12L: k=4")
par(opar)

}
\references{
\insertRef{li_constructing_2012}{T4cluster}
}
\seealso{
\code{\link{scNJW}}
}
\concept{algorithm}
