% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sphere_gskmeans.R
\name{gskmeans}
\alias{gskmeans}
\title{Geodesic Spherical K-Means}
\usage{
gskmeans(data, k = 2, ...)
}
\arguments{
\item{data}{an \eqn{(n\times p)} matrix of row-stacked observations. If not row-stochastic, each row is normalized to be unit norm.}

\item{k}{the number of clusters (default: 2).}

\item{...}{extra parameters including \describe{
\item{init}{initialization method; either \code{"kmeans"} or \code{"gmm"} (default: \code{"kmeans"}).}
\item{maxiter}{the maximum number of iterations (default: 10).}
\item{abstol}{stopping criterion to stop the algorithm (default: \eqn{10^{-8}}).}
\item{verbose}{a logical; \code{TRUE} to show iteration history or \code{FALSE} to quiet.}
}}
}
\value{
a named list of S3 class \code{T4cluster} containing 
\describe{
\item{cluster}{a length-\eqn{n} vector of class labels (from \eqn{1:k}).} 
\item{cost}{a value of the cost function.}
\item{means}{an \eqn{(k\times p)} matrix where each row is a unit-norm class mean. }
\item{algorithm}{name of the algorithm.}
}
}
\description{
Geodesic spherical \eqn{k}-means algorithm is an counterpart of the spherical \eqn{k}-means 
algorithm by replacing the cosine similarity with the squared geodesic distance, 
which is the great-circle distance under the intrinsic geometry regime 
on the unit hypersphere.  If the data is not 
normalized, it performs the normalization and proceeds thereafter.
}
\examples{
\donttest{
# -------------------------------------------------------------
#            clustering with 'household' dataset
# -------------------------------------------------------------
## PREPARE
data(household, package="T4cluster")
X   = household$data
lab = as.integer(household$gender)

## EXECUTE GSKMEANS WITH VARYING K's
vec.rand = rep(0, 9)
for (i in 1:9){
  clust_i = gskmeans(X, k=(i+1))$cluster
  vec.rand[i] = compare.rand(clust_i, lab)
}

## VISUALIZE THE RAND INDEX
opar <- par(no.readonly=TRUE)
plot(2:10, vec.rand, type="b", pch=19, ylim=c(0.5, 1),
     ylab="Rand index",xlab="number of clusters",
     main="clustering quality index over varying k's.")
par(opar)
}

}
\concept{sphere}
