% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gaterSVM.R
\name{gaterSVM}
\alias{gaterSVM}
\title{Mixture SVMs with gater function}
\usage{
gaterSVM(
  x,
  y,
  m,
  c = 1,
  max.iter,
  hidden = 5,
  learningrate = 0.01,
  threshold = 0.01,
  stepmax = 100,
  seed = NULL,
  valid.x = NULL,
  valid.y = NULL,
  valid.metric = NULL,
  verbose = FALSE,
  ...
)
}
\arguments{
\item{x}{the nxp training data matrix. Could be a matrix or an object that can be transformed into a matrix object.}

\item{y}{a response vector for prediction tasks with one value for each of the n rows of \code{x}. 
For classification, the values correspond to class labels and can be a 1xn matrix, 
a simple vector or a factor. For regression, the values correspond to the values to predict, 
and can be a 1xn matrix or a simple vector.}

\item{m}{the number of experts}

\item{c}{a positive constant controlling the upper bound of 
the number of samples in each subset.}

\item{max.iter}{the number of iterations}

\item{hidden}{the number of neurons on the hidden layer}

\item{learningrate}{the learningrate for the back propagation}

\item{threshold}{neural network stops training once all gradient is below the threshold}

\item{stepmax}{the maximum iteration of the neural network training process}

\item{seed}{the random seed. Set it to \code{NULL} to randomize the model.}

\item{valid.x}{the mxp validation data matrix.}

\item{valid.y}{if provided, it will be used to calculate the validation score with \code{valid.metric}}

\item{valid.metric}{the metric function for the validation result. By default it is the accuracy for classification.
Customized metric is acceptable.}

\item{verbose}{a logical value indicating whether to print information of training.}

\item{...}{other parameters passing to \code{neuralnet}}
}
\value{
\itemize{
   \item \code{expert} a list of svm experts
   \item \code{gater} the trained neural network model
   \item \code{valid.pred} the validation prediction
   \item \code{valid.score} the validation score
   \item \code{valid.metric} the validation metric
   \item \code{time} a list object recording the time consumption for each steps.
}
}
\description{
Implementation of Collobert, R., Bengio, S., and Bengio, Y. "A parallel mixture of SVMs for very large scale problems. Neural computation".
}
\examples{

data(svmguide1)
svmguide1.t = as.matrix(svmguide1[[2]])
svmguide1 = as.matrix(svmguide1[[1]])
gaterSVM.model = gaterSVM(x = svmguide1[,-1], y = svmguide1[,1], hidden = 10, seed = 0,
                          m = 10, max.iter = 1, learningrate = 0.01, threshold = 1, stepmax = 100,
                          valid.x = svmguide1.t[,-1], valid.y = svmguide1.t[,1], verbose = FALSE)
table(gaterSVM.model$valid.pred,svmguide1.t[,1])
gaterSVM.model$valid.score

}
