% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/surr_rsq_rank.R
\name{surr_rsq_rank}
\alias{surr_rsq_rank}
\title{The contribution of each variable in the final model}
\usage{
surr_rsq_rank(object, data, avg.num = 30, var.set = NA, ...)
}
\arguments{
\item{object}{A object of class \code{"surr_rsq"} that is generated by the function \code{"surr_rsq"}.
It contains the following components: \code{surr_rsq}, \code{reduced_model}, \code{full_model}, and \code{data}.}

\item{data}{A dataset containing the categorical responses, predictors.}

\item{avg.num}{The number of replication for the averaging of surrogate R-square.}

\item{var.set}{A list that contains a few sets. Each component of these sets represents the variables
that you want to examine for the contribution of goodness of fit. Then, for one component of this list,
a model will fit by removing the specified variables.}

\item{...}{Additional optional arguments.}
}
\value{
The default return is a list that contains the contribution of Surrogate R-squared for each
variable in the \code{full_model}. If the \code{var.set} is specified, the return is a list of the
contribution of the groups of variables in the \code{var.set}.
}
\description{
This function calculates reduction of the surrogate R-squared goodness-of-fit of each variable to measure their relative explanatory power. This function creates a table containing the reductions of surrogate R-squared by removing each one of variables in the model.
}
\examples{
data("WhiteWine")

sele_formula <- as.formula(quality ~ fixed.acidity + volatile.acidity +
                          residual.sugar +  + free.sulfur.dioxide +
                          pH + sulphates + alcohol)

sele_mod <- polr(formula = sele_formula,
              data = WhiteWine,
              method = "probit")

sur1 <- surr_rsq(model = sele_mod,
              full_model = sele_mod,
              data = WhiteWine,
              avg.num = 100)
\donttest{
rank_tab_sur1 <- surr_rsq_rank(object  = sur1,
                               data    = WhiteWine,
                               avg.num = 30)
print(rank_tab_sur1)
}

}
