% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Estimation.R
\name{FitBNR}
\alias{FitBNR}
\title{Fit Bivariate Normal Regression Model}
\usage{
FitBNR(t, s, X, Z = NULL, sig = 0.05, ...)
}
\arguments{
\item{t}{Target outcome vector.}

\item{s}{Surrogate outcome vector.}

\item{X}{Target model matrix.}

\item{Z}{Surrogate model matrix. Defaults to \code{X}.}

\item{sig}{Significance level.}

\item{...}{Additional arguments accepted if fitting via EM. See
\code{\link{FitBNEM}}.}
}
\value{
An object of class 'mnr' with slots containing the estimated regression
 coefficients, the target-surrogate covariance matrix, the information matrices
 for regression parameters, and the residuals.
}
\description{
Estimation procedure for bivariate normal regression models. The EM algorithm
is applied if \code{s} contains missing values, or if \code{X} differs from
\code{Z}. Otherwise, an accelerated least squares procedure is applied.
}
\details{
The target and surrogate model matrices are expected in numeric format.
Include an intercept if required. Expand factors and interactions in advance.
}
\examples{
\donttest{
# Case 1: No surrogate missingness.
set.seed(100)
n <- 1e3
X <- stats::rnorm(n)
data <- rBNR(
  X = X,
  Z = X,
  b = 1,
  a = -1,
  t_miss = 0.1,
  s_miss = 0.0
)
t <- data[, 1]
s <- data[, 2]

# Model fit.
fit_bnls <- FitBNR(
  t = t,
  s = s,
  X = X
)

# Case 2: Target and surrogate missingness.
set.seed(100)
n <- 1e3
X <- stats::rnorm(n)
Z <- stats::rnorm(n)
data <- rBNR(
  X = X,
  Z = Z,
  b = 1,
  a = -1,
  t_miss = 0.1,
  s_miss = 0.1
)

# Log likelihood.
fit_bnem <- FitBNR(
  t = data[, 1],
  s = data[, 2],
  X = X,
  Z = Z
)
}
}
