% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MetaAnalyticSurvBin.R
\name{plot.MetaAnalyticSurvBin}
\alias{plot.MetaAnalyticSurvBin}
\title{Generates a plot of the estimated treatment effects for the surrogate endpoint versus the estimated treatment effects for the true endpoint for an object fitted with the 'MetaAnalyticSurvBin()' function.}
\usage{
\method{plot}{MetaAnalyticSurvBin}(x, ...)
}
\arguments{
\item{x}{An object of class 'MetaAnalyticSurvBin' fitted with the 'MetaAnalyticSurvBin()' function.}

\item{...}{...}
}
\value{
A plot of the type ggplot
}
\description{
Generates a plot of the estimated treatment effects for the surrogate endpoint versus the estimated treatment effects for the true endpoint for an object fitted with the 'MetaAnalyticSurvBin()' function.
}
\examples{
\dontrun{
data("colorectal")
fit_bin <- MetaAnalyticSurvBin(data = colorectal, true = surv, trueind = SURVIND,
                               surrog = responder, trt = TREAT, center = CENTER,
                               trial = TRIAL, patientid = patientid,
                               adjustment="unadjusted")
plot(fit_bin)
}

}
