% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit_model_BinCont_copula.R
\name{binary_continuous_loglik}
\alias{binary_continuous_loglik}
\title{Loglikelihood function for binary-continuous copula model}
\usage{
binary_continuous_loglik(para, X, Y, copula_family, marginal_surrogate)
}
\arguments{
\item{para}{Parameter vector. The parameters are ordered as follows:
\itemize{
\item \code{para[1]}: mean parameter for latent true endpoint distribution
\item \code{para[2:p]}: Parameters for surrogate distribution, more details in
\code{?Surrogate::cdf_fun} for the specific implementations.
\item \code{para[p + 1]}: copula parameter
}}

\item{X}{First variable (continuous)}

\item{Y}{Second variable (binary, $0$ or $1$)}

\item{copula_family}{Copula family, one of the following:
\itemize{
\item \code{"clayton"}
\item \code{"frank"}
\item \code{"gumbel"}
\item \code{"gaussian"}
}}

\item{marginal_surrogate}{Marginal distribution for the surrogate. For all
available options, see \code{?Surrogate::cdf_fun}.}
}
\value{
(numeric) loglikelihood value evaluated in \code{para}.
}
\description{
Loglikelihood function for binary-continuous copula model
}
