% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FederatedApproachStage2.R
\name{FederatedApproachStage2}
\alias{FederatedApproachStage2}
\title{Fits the second stage model in the two-stage federated data analysis approach.}
\usage{
FederatedApproachStage2(
  Dataset,
  Intercept.S,
  alpha,
  Intercept.T,
  beta,
  sigma.SS,
  sigma.ST,
  sigma.TT,
  Obs.per.trial,
  Trial.ID,
  R.list,
  Alpha = 0.05
)
}
\arguments{
\item{Dataset}{A data frame with the correct columns (See Data Format).}

\item{Intercept.S}{Estimated intercepts for the surrogate endpoint.}

\item{alpha}{Estimated treatment effects for the surrogate endpoint.}

\item{Intercept.T}{Estimated intercepts for the true endpoint.}

\item{beta}{Estimated treatment effects for the true endpoint.}

\item{sigma.SS}{Estimated variance of the error terms for the surrogate endpoint.}

\item{sigma.ST}{Estimated covariance between the error terms of the surrogate and true endpoint.}

\item{sigma.TT}{Estimated variance of the error terms for the true endpoint.}

\item{Obs.per.trial}{Number of subjects in the trial.}

\item{Trial.ID}{Trial indicator.}

\item{R.list}{List of the variance-covariance matrices of the fixed effects.}

\item{Alpha}{The \eqn{\alpha}-level that is used to determine the confidence intervals around \eqn{R^2_{trial}} and \eqn{R^2_{indiv}}. Default 0.05.}
}
\value{
Returns an object of class "FederatedApproachStage2()" that can be used to evaluate surrogacy.
\itemize{
\item Indiv.R2: a data frame that contains the \eqn{R^2_{indiv}} and 95\% confidence interval to evaluate surrogacy at the trial level.
\item Trial.R2: a data frame that contains the \eqn{R^2_{trial}} and 95\% confidence interval to evaluate surrogacy at the trial level.
\item Fixed.Effects: a data frame that contains the average of the estimated fixed effects.
\item D: estimated \eqn{D} matrix.
\item Obs.Per.Trial: number of observations in each trial.
}
}
\description{
The function 'FederatedApproachStage2()' fits the second stage model of the two-stage federated data analysis approach to assess surrogacy.
}
\section{Model}{
The two-stage federated data analysis approach that can be used to assess surrogacy in the meta-analytic multiple-trial setting
(Continuous-continuous case), but without the need of sharing data. Instead, each organization conducts separate analyses on their data set
using the so-called "first stage" model. The results of these analyses are then aggregated at a central analysis hub,
where the aggregated results are analyzed using a "second stage" model and the necessary metrics (\eqn{R^2_{trial}} and \eqn{R^2_{indiv}})
for the validation of the surrogate endpoint are obtained. This function fits the second stage model, where a method-of-moments estimator is
used to obtain the variance-covariance matrix \eqn{D} from which the \eqn{R^2_{trial}} can be derived. The \eqn{R^2_{indiv}} is obtained with
a weighted average of the elements in \eqn{\Sigma_i}.
}

\section{Data Format}{
A data frame that combines the results of the first stage models and contains:
\itemize{
\item a column with the trial indicator
\item a column with the number of subjects in the trial
\item a column with the estimated intercepts for the surrogate
\item a column with the estimated treatment effects for the surrogate
\item a column with the estimated intercepts for the true endpoint
\item a column with the estimated treatment effects for the true endpoint
\item a column with the variances of the error term for the surrogate endpoint
\item a column with the covariances between the error terms of the surrogate and true endpoint
\item a column with the variances of the error term for the true endpoint
}

A list that combines all the variance-covariance matrices of the fixed effects obtained using the first stage model
}

\examples{
\dontrun{
#As an example, the federated data analysis approach can be applied to the Schizo data set
data(Schizo)
Schizo <-  Schizo[order(Schizo$InvestId, Schizo$Id),]
#Create separate datasets for each investigator
Schizo_datasets <- list()

for (invest_id in 1:198) {
Schizo_datasets[[invest_id]] <- Schizo[Schizo$InvestId == invest_id, ]
assign(paste0("Schizo", invest_id), Schizo_datasets[[invest_id]])
}
#Fit the first stage model for each dataset separately
results_stage1 <- list()
invest_ids <- list()
i <- 1
for (invest_id in 1:198) {
  dataset <- Schizo_datasets[[invest_id]]

  skip_to_next <- FALSE
  tryCatch(FederatedApproachStage1(dataset, Surr=CGI, True=PANSS, Treat=Treat, Trial.ID = InvestId,
                                   Min.Treat.Size = 5, Alpha = 0.05),
                                   error = function(e) { skip_to_next <<- TRUE})
  #if the trial does not have the minimum required number, skip to the next
  if(skip_to_next) { next }

  results_stage1[[invest_id]] <- FederatedApproachStage1(dataset, Surr=CGI, True=PANSS, Treat=Treat,
                                                         Trial.ID = InvestId, Min.Treat.Size = 5,
                                                         Alpha = 0.05)
  assign(paste0("stage1_invest", invest_id), results_stage1[[invest_id]])
  invest_ids[[i]] <- invest_id #keep a list of ids with datasets with required number of patients
  i <- i+1
}

invest_ids <- unlist(invest_ids)
invest_ids

#Combine the results of the first stage models
for (invest_id in invest_ids) {
  dataset <- results_stage1[[invest_id]]$Results.Stage.1
  if (invest_id == invest_ids[1]) {
    all_results_stage1<- dataset
 } else {
    all_results_stage1 <- rbind(all_results_stage1,dataset)
  }
}

all_results_stage1 #that combines the results of the first stage models

R.list <- list()
i <- 1
for (invest_id in invest_ids) {
  R <- results_stage1[[invest_id]]$R.i
  R.list[[i]] <- as.matrix(R[1:4,1:4])
  i <- i+1
}

R.list #list that combines all the variance-covariance matrices of the fixed effects

fit <- FederatedApproachStage2(Dataset = all_results_stage1, Intercept.S = Intercept.S,
                               alpha = alpha, Intercept.T = Intercept.T, beta = beta,
                               sigma.SS = sigma.SS, sigma.ST = sigma.ST,
                               sigma.TT = sigma.TT, Obs.per.trial = n,
                               Trial.ID = Trial.ID, R.list = R.list)
summary(fit)
}
}
\references{
Florez, A. J., Molenberghs G, Verbeke G, Alonso, A. (2019). A closed-form estimator for metaanalysis and surrogate markers evaluation. Journal of Biopharmaceutical Statistics, 29(2) 318-332.
}
\author{
Dries De Witte
}
