% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SupParafacEM.R
\name{SupParafacEM}
\alias{SupParafacEM}
\title{Using EM algorithm to fit the SupCP model}
\usage{
SupParafacEM(Y, X, R, AnnealIters = 100, ParafacStart = 0,
  max_niter = 1000, convg_thres = 10^-3, Sf_diag = 1)
}
\arguments{
\item{Y}{n*q full column rank reponse matrix(necessarily n>=q)}

\item{X}{n*p1*...*pk design array}

\item{R}{fixed rankd of approximation, R<=min(n,p)}

\item{AnnealIters}{Annealing iterations (default = 100)}

\item{ParafacStart}{binary argument for wether to initialize with Parafac factorization (default = 0)}

\item{max_niter}{maximum number of iterations (default = 1000)}

\item{convg_thres}{convergence threshold for difference in log likelihood (default = 10^-3)}

\item{Sf_diag}{whether Sf is diagnal (default=1,diagnoal)}
}
\value{
list with components
\item{B:}{q*r coefficient matrix for U~Y}
\item{V}{list of length K-1. V[k] is a p*r coefficient matrix with columns of norm 1}
\item{U:}{Conditional expectation of U: n*r}

\item{se2:}{scalar, var(E)}
\item{Sf:}{r*r diagonal matrix, cov(F)}
\item{rec:}{log likelihood for each iteration}
}
\description{
Using EM algorithm to fit the SupCP model
}
\examples{
sigmaF <- diag(c(100,64,36,16,4))
# F matrix n*r
Fmatrix1 <- matrix(MASS::mvrnorm(n=500,rep(0,5),sigmaF),100,5)
U<-Fmatrix1
V1 <- matrix(stats::rnorm(10*5),10,5)
V2 <- matrix(stats::rnorm(10*5),10,5)
L <- list(U,V1,V2)
X <- TensProd(L)
Y <- matrix(stats::rnorm(100*10),100,10)
R <-3
SupParafacEM(Y,X,R)

}
