% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/30-nightingale_rose.R
\name{plot_nightingale}
\alias{plot_nightingale}
\title{Nightingale plot}
\usage{
plot_nightingale(
  dat,
  covari.sel,
  trt.sel = NULL,
  resp.sel,
  outcome.type = "binary",
  seq_by = 100,
  title = NULL,
  lab.y = NULL,
  strip = "Response",
  palette_colors = c("#faa8d2", "#80b1d3")
)
}
\arguments{
\item{dat}{a data set}

\item{covari.sel}{a vector of indices of the two covariates}

\item{trt.sel}{a covariate index specifying the treatment code}

\item{resp.sel}{a covariate index specifying the response variable}

\item{outcome.type}{a string specifying the type of the response variable, it can be "continuous", or "binary" or  "survival".}

\item{seq_by}{a number specifying the breaks in the y-axis}

\item{title}{a string specifying the main title.}

\item{lab.y}{a character value specifying the label of the y axis}

\item{strip}{title for the legend}

\item{palette_colors}{the colors for the graphics, a two character vector.}
}
\description{
This function produces a nightingale plot with a binary response.
}
\examples{
library(dplyr)
dat <- prca
levels(dat$age_group) = c("Young","Middle-aged","Old")
levels(dat$weight_group)  = c("Low","Mid","High")
comb_levels = c("Young - Low", "Young - Mid", "Young - High",
                "Middle-aged - Low", "Middle-aged - Mid", "Middle-aged - High",
                "Old - Low", "Old - Mid", "Old - High")
dat \%>\%
  mutate(AgeWeight = factor(sprintf("\%s - \%s", age_group, weight_group),
                            levels = comb_levels))  \%>\%
  mutate(survival = factor(ifelse(survtime > 24 , "Yes", "No"),
                           levels = c("No", "Yes"))) \%>\%
  mutate(rx = factor(rx, labels = c("Control", "Treatment"))) -> dat

plot_nightingale(dat = dat, covari.sel = 16, resp.sel = 17,
                 strip = "2-year survival")
plot_nightingale(dat = dat, trt.sel = 3, covari.sel = 16,
                 resp.sel = 17,
                 seq_by = 50,
                 strip = "2-year survival")
}
