% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/01-level-plot-function-new.r
\name{plot_level}
\alias{plot_level}
\title{Level plot for subgroup effect size}
\usage{
plot_level(dat, covari.sel, trt.sel, resp.sel, outcome.type, ss.rect = FALSE,
  range.strip = c(-6, 6), n.brk = 30, n.brk.axis = NULL,
  font.size = c(15, 12, 0.8, 15, 0.6), title = NULL, strip = NULL,
  effect = c("HR", "RMST"), time = NULL, show.overall = FALSE,
  palette = "divergent", col.power = 0.5)
}
\arguments{
\item{dat}{a data set}

\item{covari.sel}{a vector of indices of the two covariates}

\item{trt.sel}{a covariate index which specifies the treatment code}

\item{resp.sel}{a covariate index which specifies the response variable}

\item{outcome.type}{a string specifying the type of the response variable, it can be "continuous", or "binary" or  "survival".}

\item{ss.rect}{a logical operator displaying the rectangles for subgroup sample sizes if TRUE}

\item{range.strip}{a vector with two elements specifying the range of treatment effect size for display}

\item{n.brk}{a number specifying the number of the points dividing the range of the argument "range.strip".}

\item{n.brk.axis}{a number specifying the number of breakpoints dividing the axis of the argument "range.strip".}

\item{font.size}{a vector specifying the size of labels and text; the first element is for the main title; the second element is
for the covariates labels and the colour strip label; the third is for the category labels of the first and second
covariates; the fourth is for the text in the middle cells; the fifth is for the unit label on the colour strip.}

\item{title}{a string specifying the main title.}

\item{strip}{a string specifying the title of the colour strip.}

\item{effect}{either "HR" or "RMST". only when outcome.type = "survival"}

\item{time}{time for calculating the RMST}

\item{show.overall}{logical. whether to show or not the overall treatment effect in the strip}

\item{palette}{either "divergent" or "hcl"}

\item{col.power}{to be used when palette = "hcl". see colorspace package for reference}
}
\description{
This function produces a level plot showing the treatment effect size of pairwise subgroups and marginal subgroups defined by the
categories of two covariates. Also, it prints out the minimum and maximum of the treatment effect size on the console so as to set
an approapriate range for effect size on the colour strip. Note that there are two types of graphical display; whether show subgroup
sample size by rectangles with different sizes (proportional to the ratio of sample size to the full size) or not. In addition, the
function uses log odd ratio and log hazard ratio for displaying subgroup effect sizes in binary and survival data, respectively.
}
\examples{
# Load the data to be used
data(prca)
dat  <- prca
levels(dat$age_group)    <- c("Young", "Middle-aged", "Old")
levels(dat$weight_group) <- c("Low", "Mid", "High")
names(dat)[c(14,15)]     <- c("age", "weight")

## 1.a Level plot -----------------------------------------------------------
plot_level(dat,
           covari.sel = c(14,15),
           trt.sel = 3,
           resp.sel = c(1, 2),
           outcome.type = "survival",
           ss.rect = FALSE,
           range.strip=c(-3, 3),
           n.brk = 31,
           n.brk.axis =  7,
           font.size = c(14, 12, .8, 14, 0.7),
           title = "Total sample size = 475",
           strip = "Treatment effect size (log hazard ratio)",
           effect = "HR",
           show.overall = TRUE, palette = "hcl")

## 1.b Modified Level plot --------------------------------------------------
plot_level(dat,
           covari.sel = c(14,15),
           trt.sel = 3,
           resp.sel = c(1, 2),
           outcome.type = "survival",
           ss.rect = TRUE,
           range.strip=c(-3, 3),
           n.brk = 31,
           n.brk.axis =  7,
           font.size = c(14, 12, .8, 14, 0.7),
           title = paste0("Total sample size = ", nrow(dat)),
           strip = "Treatment effect size (log hazard ratio)",
           show.overall = TRUE, palette = "hcl")
}

