% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/13-e-plt-dis-msr.r
\name{plot_dissimilarity}
\alias{plot_dissimilarity}
\title{a plot for displaying dissimilarity distances of subgroups}
\usage{
plot_dissimilarity(dat, covari.sel, mode, range.ds = c(0, 1),
  font.size = c(1, 0.9, 1, 0.7), title = NULL, lab.x = NULL)
}
\arguments{
\item{dat}{a data set}

\item{covari.sel}{a vector of indices of covariates}

\item{mode}{a value specifying the type of display; either 1 or 2.}

\item{range.ds}{a vector specifying the range of the dissimilarity distance}

\item{font.size}{a vector specifying the size of labels and text; the first element is for the title; the second is for the x-axis label; the third
is for the labels of baseline subgroups; the fourth is for the remaining subgroup labels (except for the baseline subgroup).}

\item{title}{a string specifying the main titles.}

\item{lab.x}{a string specifying the x-axis label.}
}
\description{
this function produces a plot for displaying dissimilarity distances of pairwise subgroups, where dissmiliarity distance is
defined by 1 - |intersect(A, B)|/|A|, for any sets A and B and A is the baseline set. The horizontal axis represents dissimilarity
distance. The letters represent subgroups defined by the categories of the selected covariates. The letter above the green
triangle is the baseline for calculating dissimilarity distances with the others above the red cross. There are two modes of
display - one is that subgroup letters are located at the exact dissimilarity distance; the other is that letters are located
at the middle of the category of dissimilarity distances. Note that some dissimilarity distances are known (such as 0 and 1) and
therefore they are not shown in the graphical display. Also, the range of dissimilarity distances can be adjusted.
}
\examples{
data(prca)
dat <- prca

## 1. dissimilarity plot ----------------------------------------------------
plot_dissimilarity(dat = dat,
                   covari.sel = c(4,5,6),
                   mode = 3,
                   range.ds = c(0,1),
                   font.size = c(1, 0.9, 1, 0.7),
                   title = NULL,
                   lab.x = "Dissimilarity distance")

}

