#' @title Example 7.6.2.1 from Generalized Linear Mixed Models: Modern Concepts, Methods and Applications by Walter W. Stroup (p-231)
#' @name   Exam7.6.2.1
#' @description Exam7.6.2.1 Nonlinear Mean Models ( Quantitative by quantitative models)
#' @author \enumerate{
#'          \item  Muhammad Yaseen (\email{myaseen208@@gmail.com})
#'          \item Adeela Munawar (\email{adeela.uaf@@gmail.com})
#'          }
#' @references \enumerate{
#' \item Stroup, W. W. (2012).
#'      \emph{Generalized Linear Mixed Models: Modern Concepts, Methods and Applications}.
#'        CRC Press.
#'  }
#'
#'  @seealso
#'    \code{\link{DataSet7.6}}
#'
#' @import parameters
#' @import dplyr magrittr
#' @import  scatterplot3d
#'
#'
#' @examples
#'
#' library(scatterplot3d)
#' data(DataSet7.6)
#'
#' library(dplyr)
#' library(magrittr)
#'
#' DataSet7.6 <-
#'    DataSet7.6 %>%
#'    mutate(
#'      logx1 = ifelse(test = x1 == 0, yes = log(x1 + 0.1), no = log(x1))
#'    , logx2 = ifelse(test = x2 == 0, yes = log(x2 + 0.1), no = log(x2))
#'    )
#' DataSet7.6
#' Exam7.6.2.1.lm <- lm(formula = response ~ x1*x2 + logx1*logx2 , data = DataSet7.6)
#' summary(Exam7.6.2.1.lm)
#' library(parameters)
#' model_parameters(Exam7.6.2.1.lm)
#'
#' ##---3D Scatter plot ( page#232)
#' attach(DataSet7.6)
#' (
#'   ScatterPlot1 <-
#'    scatterplot3d(
#'              x           = x1
#'            , y           = x2
#'            , z           = response
#'            , color      = response
#'            , main        = " 3D Scatter plot of response")
#'   )
#'
#' ##--- scatter plot with regression plane by using Hoerl function ( page#233)
#' grid.lines <-  5
#' x1.pred <- seq(min(x1), max(x1), length.out = grid.lines)
#' x2.pred <- seq(min(x2), max(x2), length.out = grid.lines)
#' x1x2    <- expand.grid( x = x1.pred, y = x2.pred)
#'
#' z.pred  <- matrix(data = predict(Exam7.6.2.1.lm, newdata = x1x2),
#'                   nrow = grid.lines
#'                 , ncol = grid.lines)
#' (ScatterPlot2 <-
#'    scatterplot3d(
#'              x           = x1
#'            , y           = x2
#'            , z           = response
#'            , pch         = 20
#'            , phi         = 25
#'            , theta       = 30
#'            , ticktype   = "detailed"
#'            , xlab       =  "x1"
#'            , ylab       =  "x2"
#'            , zlab       = "response"
#'            , add         = FALSE
#'            , surf        = list(x      = x1.pred ,
#'                                 y      = x2.pred ,
#'                                 z      = z.pred  ,
#'                                 facets = NA
#'                                 )
#'            , plot        = TRUE
#'            , main        = "Fitted Response Surface by Hoerl Function"
#'            )
#'            )
NULL


