% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/construct_DesMat.R
\name{construct_timeadjust}
\alias{construct_timeadjust}
\title{Construct the time period adjustment in the design matrix}
\usage{
construct_timeadjust(
  Cl,
  timepoints,
  timeAdjust = "factor",
  period = NULL,
  timeBlk = NULL
)
}
\arguments{
\item{Cl}{integer (vector), number of clusters per sequence group (in SWD),
or number in control and intervention (in parallel designs)}

\item{timepoints}{numeric (scalar or vector), number of timepoints (periods).
If design is swd, timepoints defaults to length(Cl)+1.
Defaults to 1 for parallel designs.}

\item{timeAdjust}{character, specifies adjustment for time periods.
One of the following: "factor", "linear", "none", "periodic".
Defaults to "factor".}

\item{period}{numeric (scalar)}

\item{timeBlk}{an optional user defined matrix that defines
the time adjustment in one cluster.
Is repeated for every cluster.}
}
\value{
a matrix with one row for every cluster at every timepoint and columns
depending of adjustment type.
}
\description{
Construct the time period adjustment in the design matrix
}
