% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/decTreeImpFunc.R
\name{decTreeImpFunc}
\alias{decTreeImpFunc}
\title{Decision Tree for Ranking Data-Impurity Function Approach}
\usage{
decTreeImpFunc(ITEM_SIZE, RANK_SIZE, CART_SIZE, DATA_FILE, INFO_FILE,
  OUTPUT_FILE, mode = c("E", "G", "S", "C"), TMODE = c("L", "P"),
  usePairwise = FALSE, isPW_DATA = FALSE, prediction = c("M", "F", "C"),
  NODE_SIZE = 400, MIN_NODE_SIZE = 400, RANK_ITEM = 2, ST_ALP = 0.95,
  CHI_ALP = 0.2, TRAIN_PROP = 1, useCV_TEST = FALSE, TEST_STAGE = 0)
}
\arguments{
\item{ITEM_SIZE}{number of items}

\item{RANK_SIZE}{top-q size}

\item{CART_SIZE}{number of cross validation in tree pruning}

\item{DATA_FILE}{please specify the input file as fullpath/input_file.txt}

\item{INFO_FILE}{please specify the input file as fullpath/input_file.txt, note that the data should be
seperated by tab.}

\item{OUTPUT_FILE}{name of the output file}

\item{mode}{Spliting Criterion: E = Entropy G = Gini S = Statistical Test C = Chi-square test}

\item{TMODE}{When mode = "C" P = Pearson Chi-square test; L =  Likelihood ratio test}

\item{usePairwise}{use pairwise comparison model or not}

\item{isPW_DATA}{use pairwise data or top k-ranked data}

\item{prediction}{M : mean, F : frequency, C : center}

\item{NODE_SIZE}{usually one tenth of the number of observations}

\item{MIN_NODE_SIZE}{min NODE_DIZE}

\item{RANK_ITEM}{top-q measure (1-3)}

\item{ST_ALP}{level of significance of Statistical test}

\item{CHI_ALP}{level of significance of Chi-square test}

\item{TRAIN_PROP}{proportion of training data; effective only when CV_TEST = false}

\item{useCV_TEST}{use 10-fold CV testing or not}

\item{TEST_STAGE}{the stage of the 10-fold CV testing; effective only when CV_TEST = true; value starts from 0 to V-1}
}
\value{
a list contains the information of the tree
}
\description{
See Section 10.1 of the book for more details
}
\examples{
#see example 10.1.4.R on the websited for more details.
}
\author{
Li Qinglong <liqinglong0830@163.com>, William Lai
}
\references{
Decision tree modeling for ranking data, Yu, P.L.H.,Wan, W. M.,& Lee, P.H.(2010)
}

