% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hist_3d.R
\name{hist_3d}
\alias{hist_3d}
\title{hist_3d}
\usage{
hist_3d(
  x,
  y,
  z,
  breaks_x,
  breaks_y,
  breaks_z,
  same.scale = FALSE,
  na.rm = TRUE,
  FUN = length
)
}
\arguments{
\item{x}{either a numerical vector to be partitioned or a matrix with 3 numerical 
columns to be partitioned.}

\item{y}{a numerical vector to be partitioned. Not required if x is a matrix.}

\item{z}{a numerical vector to be partitioned. Not required if x is a matrix}

\item{breaks_x}{a numerical vector. Contains the breaks related to x for the
histogram}

\item{breaks_y}{a numerical vector. Contains the breaks related to y for the
histogram}

\item{breaks_z}{a numerical vector. Contains the breaks related to z for the
histogram}

\item{same.scale}{logical. Default to FALSE. If TRUE, breaks_x will be used
for x, y and z}

\item{na.rm}{logical. Default to TRUE. Indicates whether missing values
should be removed}

\item{FUN}{function used to summarize bin contents.}
}
\value{
Using a given set of breaks per each variable, the function returns :
\describe{
\item{Hist.Values}{a 3 dimensional array. The 1st (respectively 2nd, 3rd) dimension  is 
related to the class intervals of x (resp. y, z). Contingency table is returned if
 FUN=length}
\item{breaks_x, breaks_y, breaks_z }{ same as the inputs of the function}
\item{Midpoints.x, Midpoints.y, Midpoints.z }{the midpoints for each bin
per variable}
\item{nobs.x , nobs.y, nobs.z }{number of observations of x, y and z}
\item{n.bins}{ vector of 3 elements containing the number of bins for x, y
and z }
}
}
\description{
This function can be used in order to construct a 3D histogram based on 3
variables and relative breaks directly provided as inputs.
}
\details{
The default function used for the argument FUN is the function
length. When another function is used, it is applied on x or on the first column
of x if this is a three-column matrix. The lower limit of each class interval is
included in the class and the upper limit is not.
}
\examples{
set.seed(4)
hist_3d(x = rnorm(1000),
        y = rnorm( 1000,5,0.1),
        z = rnorm( 1000,2,1),
        breaks_x = seq(-4, 4, by =1),
        breaks_y = seq(2, 8, by =1),
        breaks_z = seq(-2, 6, by =1))
}
