\name{TestRankhist}
\alias{TestRankhist}
\title{Statistical tests for rank histograms}
\description{
  Perform statistical tests related to the deviation from flatness of a rank histogram.
}
\usage{
TestRankhist(rank.hist)
}
\arguments{
  \item{rank.hist}{Vector of rank counts. Generated by function `Rankhist()`}
}
\value{
A dataframe whose columns refer to the Pearson Chi^2 statistic, the Jolliffe-Primo test statistic for slope, and the Jolliffe-Primo test statistic for convexity. The rows refer to the actual test statistic and its p-value under the null hypothesis of an asymptotically flat rank histogram.
}
\details{
Given a vector of rank counts `x`, the Pearson Chi^2 statistic is calculated by

sum((x - sum(x)/length(x))^2 / (sum(x)/length(x)))

and has a chi^2 distribution with (length(x)-1) degrees of freedom if every rank is equally likely on average.
The Jolliffe-Primo test statistics are calculated by projecting the vector

(x-sum(x)/length(x)) / sqrt(sum(x)/length(x))

onto a linear, respectively squared contrast, i.e. a linear and quadratic function defined over the index set 1:length(x), who are mutually orthogonal, whose elements sum to zero, and whose squared elements sum to one. The projections independently have chi^2 distributions with 1 degree of freedom under the null hypothesis of an asymptotically flat rank histogram.
}
\examples{
  # Example:
  ens <- matrix(rnorm(500),100,5)
  obs <- rnorm(100)
  rh <- Rankhist(ens, obs)
  TestRankhist(rh)
}

\references{
Pearson K. (1900): X. On the criterion that a given system of deviations from the probable in the case of a correlated system of variables is such that it can be reasonably supposed to have arisen from random sampling.  Phil. Mag. Series 5, 50(302) DOI: 10.1080/14786440009463897.

Jolliffe I.T., Primo C. (2008): Evaluating rank histograms using decompositions of the chi-square test statistic. Mon. Wea. Rev. 136(6) DOI: 10.1175/2007MWR2219.1
}

