% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getGamutValues.R
\name{getGamutValues}
\alias{getGamutValues}
\alias{getWhiteValues}
\alias{getWhiteValues}
\title{Look up gamut and white point values in the 1931 CIE system}
\usage{
getGamutValues(gamut)

getWhiteValues(white)
}
\arguments{
\item{gamut}{A character string giving the name of the desired gamut.  One of
\code{c("Apple", "CIE", "Adobe", "sRGB", "NTSC", "SWOP")}.}

\item{white}{The desired white point value.  One of \code{c("D65", "E", "C", "D50")}.}
}
\value{
A data frame with columns x, y containing the vertices of the
requested gamut in CIE chromaticity coordinates, or, for a white point,
a data frame containing the coordinates of the requested white point.
}
\description{
These functions provide a simple way of storing white point and
gamut data for use in drawing CIE chromaticity diagrams.
}
\seealso{
\code{\link{plotCIEchrom}} for examples of this function in use.
}
\author{
Bryan A. Hanson, DePauw University. \email{hanson@depauw.edu}
}
\keyword{utilities}
