% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kde.R
\name{kde}
\alias{kde}
\title{Kernel Density Estimation}
\usage{
kde(
  points,
  band_width,
  decay = 1,
  kernel = c("quartic", "uniform", "triweight", "epanechnikov", "triangular"),
  scaled = FALSE,
  weights = c(),
  grid,
  cell_size
)
}
\arguments{
\item{points}{\code{\link[sf]{sf}} \code{data.frame} containing only POINTS.}

\item{band_width}{\code{numeric} specifying the band width for KDE.}

\item{decay}{\code{numeric} specifying the decay parameter for \code{"triangular"} kernel. For
other kernels besides \code{"triangular"} the parameter is not used.}

\item{kernel}{\code{character} specifying type of kernel to use. Available implemented kernels are
\code{"uniform", "quartic", "triweight", "epanechnikov", "triangular"}. Default is \code{"quartic"} and if
unknown kernel name is used it falls back to the default value.}

\item{scaled}{\code{logical} specifying if the output values should be scaled. Default value is
\code{FALSE}.}

\item{weights}{\code{numeric} vector of weights for individual \code{points}.}

\item{grid}{either \code{\link[sf]{sf}} \code{data.frame} (outcome of function
\code{\link{create_grid_rectangular}} or \code{\link{create_grid_hexagonal}}) or
\code{\link[raster]{Raster-class}} (outcome of function \code{\link{create_raster}}).
Does not have to be specified if \code{cell_size} is set.}

\item{cell_size}{\code{numeric} specifying the distance for equal spaced points. Must be
higher than 0. Can be left out if \code{grid} is provided as \code{grid} is used instead.
The code used to generate grid is \code{\link{create_grid_rectangular}(points, cell_size, band_width)}.}
}
\value{
either \code{\link[sf]{sf}} \code{data.frame} or \code{\link[raster]{Raster-class}}
depending on class of \code{grid} parameter.
}
\description{
KDE for spatial data. The algorithm is heavily inspired by
\href{https://github.com/qgis/QGIS/blob/b3d2619976a69d7fb67b884492da491dfaba287c/src/analysis/raster/qgskde.cpp}{Heatmap tool}
in QGIS. The help for QGIS tools is provided \href{https://docs.qgis.org/testing/en/docs/user_manual/processing_algs/qgis/interpolation.html#heatmap-kernel-density-estimation}{at the QGIS website}.
The a tutorial is provided \href{https://grindgis.com/software/heat-map-using-qgis}{here}.
}
\details{
\code{grid} parameter specifies output of the function. KDE is calculated on the specified \code{grid}.
If grid is \code{\link[raster]{Raster-class}} then outcome is also \code{\link[raster]{Raster-class}}.
If grid is \code{\link[sf]{sf}} \code{data.frame} then outcome is also \code{\link[sf]{sf}} \code{data.frame}.
}
\examples{
library(sf)
nc <- st_read(system.file("shape/nc.shp", package = "sf")) \%>\% st_transform(32031)
grid <- create_grid_hexagonal(nc, cell_size = 100000)
points <- st_sample(nc, 500) \%>\% st_as_sf()
kde_estimate_grid <- kde(points, band_width = 150000, grid = grid)
raster <- create_raster(nc, cell_size = 100000)
kde_estimate_raster <- kde(points, band_width = 150000, grid = raster)

}
