% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_raster.R
\name{create_raster}
\alias{create_raster}
\title{Create raster}
\usage{
create_raster(geometry, cell_size, side_offset = 0)
}
\arguments{
\item{geometry}{\code{\link[sf]{sf}} \code{data.frame} containing geometry which should be cover by
the raster.}

\item{cell_size}{\code{numeric} specifying the distance for equally spaced cells.}

\item{side_offset}{\code{numeric} specifying the side offset, distance added to the convex hull
of input geometry to generate raster for KDE. Good estimate is usually the same value as band width of KDE.}
}
\value{
\code{\link[raster]{Raster-class}}
}
\description{
Create raster of equally spaced cells. The distance between centre of cells
in both x and y dimension is equal to \code{cell_size}.
}
\examples{
library(sf)
nc <- st_read(system.file("shape/nc.shp", package="sf")) \%>\% st_transform(32031)
raster <- create_raster(nc, cell_size = 100000)

}
