% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotSpatialCoor.R
\name{plotSpatialGeneExpr}
\alias{plotSpatialGeneExpr}
\title{Plot normalized gene expression data (logCPM) in spatial coordinates}
\usage{
plotSpatialGeneExpr(
  object,
  index.st,
  gene,
  colors = "spectral",
  size.point = 1,
  title = NULL,
  theme = NULL
)
}
\arguments{
\item{object}{A \code{\linkS4class{SpatialDDLS}} object.}

\item{index.st}{Index of the spatial transcriptomics data to be plotted. It
can be either a position or a name if a named list of
\code{\link[SpatialExperiment]{SpatialExperiment}} objects was provided.}

\item{gene}{Gene to color spots by.}

\item{colors}{Color scale to be used. It can be \code{"blues"} or
\code{"spectral"} (the latter by default).}

\item{size.point}{Size of points (0.1 by default).}

\item{title}{Title of plot.}

\item{theme}{\pkg{ggplot2} theme.}
}
\value{
A ggplot object.
}
\description{
Color spots on the spatial coordinates according to the logCPM values of a
particular gene.
}
\seealso{
\code{\link{interGradientsDL}} \code{\link{topGradientsCellType}}
}
