% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stats.R
\docType{methods}
\name{crosstab}
\alias{crosstab}
\alias{crosstab,SparkDataFrame,character,character-method}
\title{Computes a pair-wise frequency table of the given columns}
\usage{
\S4method{crosstab}{SparkDataFrame,character,character}(x, col1, col2)
}
\arguments{
\item{x}{a SparkDataFrame}

\item{col1}{name of the first column. Distinct items will make the first item of each row.}

\item{col2}{name of the second column. Distinct items will make the column names of the output.}
}
\value{
a local R data.frame representing the contingency table. The first column of each row
        will be the distinct values of \code{col1} and the column names will be the distinct values
        of \code{col2}. The name of the first column will be "\code{col1}_\code{col2}". Pairs
        that have no occurrences will have zero as their counts.
}
\description{
Computes a pair-wise frequency table of the given columns. Also known as a contingency
table. The number of distinct values for each column should be less than 1e4. At most 1e6
non-zero pair frequencies will be returned.
}
\note{
crosstab since 1.5.0
}
\examples{
\dontrun{
df <- read.json("/path/to/file.json")
ct <- crosstab(df, "title", "gender")
}
}
\seealso{
Other stat functions: \code{\link{approxQuantile}},
  \code{\link{corr}}, \code{\link{cov}},
  \code{\link{freqItems}}, \code{\link{sampleBy}}
}
