% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simList-class.R
\docType{class}
\name{.simList-class}
\alias{.simList-class}
\alias{.simList}
\alias{simList-class}
\alias{simList}
\title{The \code{simList} class}
\description{
Contains the minimum components of a \code{SpaDES} simulation.
Various slot accessor methods (i.e., get and set functions) are provided
(see 'Accessor Methods' below).
}
\details{
Based on code from chapter 7.8.3 of Matloff (2011): "Discrete event simulation".
Here, we implement a discrete event simulation in a more modular fashion so
it's easier to add simulation components (i.e., "simulation modules").
We use S4 classes and methods, and use \code{\link{data.table}} instead of
\code{\link{data.frame}} to implement the event queue (because it is much
more efficient).
}
\section{Slots}{

\describe{
\item{\code{modules}}{List of character names specifying which modules to load.}

\item{\code{params}}{Named list of potentially other lists specifying simulation
parameters.}

\item{\code{events}}{The list of scheduled events (i.e., event queue), as a
\code{data.table}. See 'Event Lists' for more information.}

\item{\code{current}}{The current event, as a \code{data.table}.
See 'Event Lists' for more information..}

\item{\code{completed}}{The list of completed events, as a \code{list}.
See 'Event Lists' for more information. It is kept
as a list of individual events for speed. The \code{completed}
method converts it to a sorted \code{data.table}.}

\item{\code{depends}}{A \code{.simDeps} list of \code{\link{.moduleDeps}} objects
containing module object dependency information.}

\item{\code{simtimes}}{List of numerical values describing the simulation start
and end times; as well as the current simulation time.}

\item{\code{inputs}}{a \code{data.frame} or \code{data.table} of files and
metadata}

\item{\code{outputs}}{a \code{data.frame}  or \code{data.table} of files and
metadata}

\item{\code{paths}}{Named list of \code{modulePath}, \code{inputPath},
and \code{outputPath} paths. Partial matching is performed.}

\item{\code{.envir}}{Environment referencing the objects used in the simulation.
Several "shortcuts" to accessing objects referenced by this
environment are provided, and can be used on the
\code{simList} object directly instead of specifying the
\code{.envir} slot: \code{$}, \code{[[}, \code{ls},
\code{ls.str}, \code{objs}. See examples.}
}}

\note{
The \code{simList} class extends the \code{.simList} superclass by adding
a slot \code{.envir} to store the simulation environment containing references
to simulation objects.
The \code{\link{simList_}} class extends the \code{.simList} superclass, by
adding a slot \code{.list} containing the simulation objects.
Thus, \code{simList} is identical to \code{simList_}, except that the former
uses an environment for objects and the latter uses a list.
The class \code{simList_} is only used internally.
}
\section{Accessor Methods}{


Several slot (and sub-slot) accessor methods are provided for use, and
categorized into separate help pages:
\tabular{ll}{
  \code{\link{simList-accessors-envir}} \tab Simulation environment. \cr
  \code{\link{simList-accessors-events}} \tab Scheduled and completed events. \cr
  \code{\link{simList-accessors-inout}} \tab Passing data in to / out of simulations. \cr
  \code{\link{simList-accessors-modules}} \tab Modules loaded and used; module dependencies. \cr
  \code{\link{simList-accessors-objects}} \tab Accessing objects used in the simulation. \cr
  \code{\link{simList-accessors-params}} \tab Global and module-specific parameters. \cr
  \code{\link{simList-accessors-paths}} \tab File paths for modules, inputs, and outputs. \cr
  \code{\link{simList-accessors-times}} \tab Simulation times. \cr
}
}

\section{Event Lists}{


The main event list is a sorted data.table (keyed) on eventTime, and eventPriority.
The completed event list is an ordered list in the exact order that the events
were executed.
Each event is represented by a \code{\link{data.table}} row consisting of:
\tabular{ll}{
  \code{eventTime} \tab The time the event is to occur.\cr
  \code{moduleName} \tab The module from which the event is taken.\cr
  \code{eventType} \tab A character string for the programmer-defined event type.\cr
  \code{eventPriority} \tab The priority given to the event. \cr
}
}

\references{
Matloff, N. (2011). The Art of R Programming (ch. 7.8.3).
            San Francisco, CA: No Starch Press, Inc..
            Retrieved from \url{https://www.nostarch.com/artofr.htm}
}
\author{
Alex Chubaty and Eliot McIntire
}
