% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/misc-methods.R
\docType{methods}
\name{append_attr}
\alias{append_attr}
\alias{append_attr,list,list-method}
\title{Add a module to a \code{moduleList}}
\usage{
append_attr(x, y)

\S4method{append_attr}{list,list}(x, y)
}
\arguments{
\item{x}{A \code{list} of items with optional attributes.}

\item{y}{See \code{x}.}
}
\value{
An updated \code{list} with attributes.
}
\description{
Ordinary base lists and vectors do not retain their attributes when subsetted
or appended. This function appends items to a list while preserving the
attributes of items in the list (but not of the list itself).
}
\details{
Similar to \code{updateList} but does not require named lists.
}
\examples{
library(igraph) # igraph exports magrittr's pipe operator
tmp1 <- list("apple", "banana") \%>\% lapply(., `attributes<-`, list(type = "fruit"))
tmp2 <- list("carrot") \%>\% lapply(., `attributes<-`, list(type = "vegetable"))
append_attr(tmp1, tmp2)
rm(tmp1, tmp2)
}
\author{
Alex Chubaty and Eliot McIntire
}
