% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datagen.R
\name{gendata_spacoap}
\alias{gendata_spacoap}
\title{Generate simulated data}
\usage{
gendata_spacoap(
  seed = 1,
  width = 20,
  height = 30,
  p = 500,
  d = 40,
  k = 3,
  q = 5,
  rank0 = 3,
  eta0 = 0.5,
  bandwidth = 1,
  rho = c(10, 1),
  sigma2_eps = 1,
  seed.beta = 1
)
}
\arguments{
\item{seed}{a postive integer, the random seed for reproducibility of data generation process.}

\item{width}{a postive integer, specify the width of the spatial grid.}

\item{height}{a postive integer, specify the height of the spatial grid.}

\item{p}{a postive integer, specify the dimension of count variables.}

\item{d}{a postive integer,  specify the dimension of covariate matrix with low-rank regression coefficient matrix.}

\item{k}{a postive integer,  specify the dimension of  covariate matrix as control variables.}

\item{q}{a postive integer,  specify the number of factors.}

\item{rank0}{a postive integer, specify the rank of the coefficient matrix.}

\item{eta0}{a real between 0 and 1, specify the spatial autocorrelation parameter.}

\item{bandwidth}{a real positive value, specify the bandwidth in calculating the weighted adjacency matrix.}

\item{rho}{a numeric vector with length 2 and positive elements, specify the signal strength of loading matrix and regression coefficient, respectively.}

\item{sigma2_eps}{a positive real, the variance of overdispersion error.}

\item{seed.beta}{a postive integer, the random seed for reproducibility of data generation process by fixing the regression coefficient matrix beta.}
}
\value{
return a list including the following components:
\itemize{
  \item \code{X} - the high-dimensional count matrix; 
  \item \code{Z} - the low-dimensional covariate matrix with control variables.
  \item \code{H} - the high-dimensional covariate matrix;
  \item \code{Adj_sp} - the weighted adjacence matrix;
  \item \code{alpha0} - the regression coefficient matrix corresponing to Z;
  \item \code{bbeta0} - the low-rank large regression coefficient matrix corresponing to H; 
  \item \code{B0} - the loading matrix;
  \item \code{F0} -  the laten factor matrix;
  \item \code{rank0} - the true rank of bbeta0;
  \item \code{q} - the true number of factors;
  \item \code{eta0} - spatial autocorrelation parameter;
  \item \code{pos} - spatial coordinates for each observation.
}
}
\description{
Generate simulated data from spaital covariate-augmented Poisson factor models
}
\details{
None
}
\examples{
width <- 20; height <- 15; p <- 100
d <- 20; k <- 3; q <- 6; r <- 3
datlist <- gendata_spacoap(width=width, height=height, p=p, d=20, k=k, q=q, rank0=r)
str(datlist)
}
\references{
None
}
\seealso{
\code{\link{SpaCOAP}}
}
