% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SpaCCRFunctions.R
\name{SpaCC_Methy}
\alias{SpaCC_Methy}
\title{Performs Spatial Convex Clustering for methylation data}
\usage{
SpaCC_Methy(X, Coordinates, gamma.seq, dist.cutoff = 20000, sig = 1/5000,
  weights = NULL, center = TRUE, scale = FALSE, nfolds = 5, nu = NULL,
  tol.base = 1e-04, tol.miss = 1e-04, max.iter.base = 5000,
  max.iter.miss = 500, frac = 0.1, parallel = FALSE, gam.rule = 2,
  thresh.mult = 1, thresh.value = NULL)
}
\arguments{
\item{X}{A subject (n) by variable (p) matrix; the data}

\item{Coordinates}{a vector listing genomic coordinates}

\item{gamma.seq}{a vector of regularization parameters}

\item{dist.cutoff}{maximum distance at which probes should be regularized}

\item{sig}{positive scalar controling spatial weight decay}

\item{weights}{a vector of spatial weights}

\item{center}{should data be centered}

\item{scale}{should data be scaled}

\item{nfolds}{number of folds for cross validation}

\item{nu}{parameter for augmented lagrangian}

\item{tol.base}{tolerance level for base function}

\item{tol.miss}{tolerance for missing function}

\item{max.iter.base}{maximum number of iterations for base function}

\item{max.iter.miss}{maximum number of iterations for missing function}

\item{frac}{fration of fold to use for cross validation}

\item{parallel}{should algorithm be run in parallel}

\item{gam.rule}{cross validation rule}

\item{thresh.mult}{multiplier for threshold value}

\item{thresh.value}{value of threshold}
}
\value{
Labels a vector of cluster labels
}
\description{
Performs Spatial Convex Clustering for methylation data
}
\examples{
data("methy")
methy <- methy[1:20,1:10]
library(dplyr)
library(tidyr)
Coordinates <- methy$Genomic_Coordinate
methy \%>\%
 tbl_df() \%>\%
 select(-Chromosome,-Genomic_Coordinate) \%>\%
 gather(Subject,Value,-ProbeID) \%>\%
 spread(ProbeID,Value) -> X
SubjectLabels <- X$Subject
X <- X[,-1] \%>\% as.matrix()
verbose=TRUE
tol.base = 1e-4
tol.miss = 1e-4
max.iter.base=5000
max.iter.miss=500
ngam = 20
gamma.seq <- exp(seq(log(1e-1),log(1e1),length.out=ngam))
ClusterLabels <- SpaCC_Methy(X = X,Coordinates = Coordinates,gamma.seq = gamma.seq)
}

