% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/subpop.R
\name{plot.subpop}
\alias{plot.subpop}
\title{Plot 2-dimensional projections of variables in interest.}
\usage{
\method{plot}{subpop}(
  x,
  varx,
  vary,
  xlim = NULL,
  ylim = NULL,
  main = NULL,
  sub = NULL,
  xlab = NULL,
  ylab = NULL,
  overlap = FALSE,
  ...
)
}
\arguments{
\item{x}{Output of \code{\link{subpop}} command.}

\item{varx}{The name of the variable to be plotted on the x-axis.}

\item{vary}{The name of the variable name to be plotted on the
y-axis.}

\item{xlim}{The range of x-axis. Default is \code{NULL}.}

\item{ylim}{The range of y-axis. Default is \code{NULL}. If the
variable on the y-coordinate is a factor, the default
will set it to be the factor level, and users don't
need to specify \code{ylim}.}

\item{main}{Main title of the plot. Default is \code{NULL}.}

\item{sub}{Sub title of the plot. Default is NULL.}

\item{xlab}{x-axis label. Default is \code{NULL}.}

\item{ylab}{y-axis label. Default is \code{NULL}.}

\item{overlap}{Whether user wants to allow observations included in both
confidence sets. Default is \code{FALSE}, and the plot
drops the overlapped observations.}

\item{...}{Graphics parameters to be passed to the plotting
routines.}
}
\description{
Takes output from \code{\link{subpop}} command as inputs and plots
2-dimensional projection plots of two specified variables. If a
variable in interest is of type factor, then the user must put it on
the y-axis. If the variable on the y-coordinate is a factor, range of
y-axis is set to be the factor level. Otherwise, users can use
\code{\link{summary.subpop}} to know the ranges of variables in the
two groups.
}
\examples{
data("mortgage")
### Regression Specification
fm <- deny ~ black + p_irat + hse_inc + ccred + mcred + pubrec +
   ltv_med + ltv_high + denpmi + selfemp + single + hischl
### Issue the subpop command
set_b <- subpop(fm, data = mortgage, method = "logit", var = "black",
u = 0.1, alpha = 0.1, b = 50)
### Plotting
plot(set_b, varx = mortgage$p_irat, vary = mortgage$hse_inc,
     xlim = c(0, 1.5), ylim = c(0, 1.5), xlab = "Debt/Income",
     ylab = "Housing expenses/Income", overlap = TRUE)
}
