% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/s3-soma-adat.R, R/s3-print-soma-adat.R,
%   R/s3-summary-soma-adat.R
\name{soma_adat}
\alias{soma_adat}
\alias{print.soma_adat}
\alias{summary.soma_adat}
\alias{[.soma_adat}
\alias{$.soma_adat}
\alias{[[.soma_adat}
\alias{[<-.soma_adat}
\alias{$<-.soma_adat}
\alias{[[<-.soma_adat}
\alias{median.soma_adat}
\title{The \code{soma_adat} Class and S3 Methods}
\usage{
\method{print}{soma_adat}(x, show_header = FALSE, ...)

\method{summary}{soma_adat}(object, tbl = NULL, digits = max(3L, getOption("digits") - 3L), ...)

\method{[}{soma_adat}(x, i, j, drop = TRUE, ...)

\method{$}{soma_adat}(x, name)

\method{[[}{soma_adat}(x, i, j, ..., exact = TRUE)

\method{[}{soma_adat}(x, i, j, ...) <- value

\method{$}{soma_adat}(x, i, j, ...) <- value

\method{[[}{soma_adat}(x, i, j, ...) <- value

\method{median}{soma_adat}(x, na.rm = FALSE, ...)
}
\arguments{
\item{x, object}{A \code{soma_adat} class object.}

\item{show_header}{Logical. Should all the \verb{Header Data} information
be displayed instead of the data frame (\code{tibble}) object?}

\item{...}{Ignored.}

\item{tbl}{An annotations table. If \code{NULL} (default),
annotation information is extracted from the object itself (if possible).
Alternatively, the result of a call to \code{\link[=getAnalyteInfo]{getAnalyteInfo()}}, from
which Target names can be extracted.}

\item{digits}{Integer. Used for number formatting with \code{\link[=signif]{signif()}}.}

\item{i, j}{Row and column indices respectively. If \code{j} is omitted,
\code{i} is used as the column index.}

\item{drop}{Coerce to a vector if fetching one column via \code{tbl[, j]}.
Default \code{FALSE}, ignored when accessing a column via \code{tbl[j]}.}

\item{name}{A \link{name} or a string.}

\item{exact}{Ignored with a \code{\link[=warning]{warning()}}.}

\item{value}{A value to store in a row, column, range or cell.}

\item{na.rm}{a logical value indicating whether \code{NA}
    values should be stripped before the computation proceeds.}
}
\value{
The set of S3 methods above return the \code{soma_adat} object with
the corresponding S3 method applied.
}
\description{
The \code{soma_adat} data structure is the primary internal \code{R} representation
of SomaScan data. A \code{soma_adat} is automatically created via \code{\link[=read_adat]{read_adat()}}
when loading a \verb{*.adat} text file. It consists of a \code{data.frame}-like
object with leading columns as clinical variables and SomaScan RFU data
as the remaining variables. Two main attributes corresponding to analyte
and SomaScan run information contained in the \verb{*.adat} file are added:
\itemize{
\item \code{Header.Meta}: information about the SomaScan run, see \code{\link[=parseHeader]{parseHeader()}}
or \code{attr(x, "Header.Meta")}
\item \code{Col.Meta}: annotations information about the SomaScan reagents/analytes,
see \code{\link[=getAnalyteInfo]{getAnalyteInfo()}} or \code{attr(x, "Col.Meta")}
\item \code{file_specs}: parsing specifications for the ingested \verb{*.adat} file
\item \code{row_meta}: the names of the non-RFU fields. See \code{\link[=getMeta]{getMeta()}}.
}
See \code{\link[=groupGenerics]{groupGenerics()}} for a details on \code{\link[=Math]{Math()}}, \code{\link[=Ops]{Ops()}}, and \code{\link[=Summary]{Summary()}}
methods that dispatch on class \code{soma_adat}.
\cr\cr
See \code{\link[=reexports]{reexports()}} for a details on re-exported S3 generics from other
packages (mostly \code{dplyr} and \code{tidyr}) to enable S3 methods to be
dispatched on class \code{soma_adat}.
\cr\cr
Below is a list of \emph{all} currently available S3 methods that dispatch on
the \code{soma_adat} class:

\if{html}{\out{<div class="sourceCode">}}\preformatted{#>  [1] [            [[           [[<-         [<-          ==          
#>  [6] $            $<-          anti_join    arrange      count       
#> [11] filter       full_join    getAnalytes  getMeta      group_by    
#> [16] inner_join   is_seqFormat left_join    Math         median      
#> [21] merge        mutate       Ops          print        rename      
#> [26] right_join   sample_frac  sample_n     select       semi_join   
#> [31] separate     slice_sample slice        summary      Summary     
#> [36] transform    ungroup      unite       
#> see '?methods' for accessing help and source code
}\if{html}{\out{</div>}}

The S3 \code{\link[=print]{print()}} method returns summary information parsed from the object
attributes, if present, followed by a dispatch to the \code{\link[=tibble]{tibble()}} print method.
Rownames are printed as the first column in the print method only.

The S3 \code{\link[=summary]{summary()}} method returns the following for each column of the ADAT
object containing SOMAmer data (clinical meta data is \emph{excluded}):
\itemize{
\item Target (if available)
\item Minimum value
\item 1st Quantile
\item Median
\item Mean
\item 3rd Quantile
\item Maximum value
\item Standard deviation
\item Median absolute deviation (\code{\link[=mad]{mad()}})
\item Interquartile range (\code{\link[=IQR]{IQR()}})
}

The S3 \code{\link[=Extract]{Extract()}} method is used for sub-setting a \code{soma_adat}
object and relies heavily on the \code{[} method that maintains the \code{soma_adat}
attributes intact \emph{and} subsets the \code{Col.Meta} so that it is consistent
with the newly created object.

S3 extraction via \code{$} is fully supported, however,
as opposed to the \code{data.frame} method, partial matching
is \emph{not} allowed for class \code{soma_adat}.

S3 extraction via \code{[[} is supported, however, we restrict
the usage of \code{[[} for \code{soma_adat}. Use only a numeric index (e.g. \code{1L})
or a character identifying the column (e.g. \code{"SampleID"}).
Do not use \verb{[[i,j]]} syntax with \code{[[}, use \code{[} instead.
As with \code{$}, partial matching is \emph{not} allowed.

S3 assignment via \code{[} is supported for class \code{soma_adat}.

S3 assignment via \code{$} is fully supported for class \code{soma_adat}.

S3 assignment via \code{[[} is supported for class \code{soma_adat}.

S3 \code{\link[=median]{median()}} is \emph{not} currently supported for the \code{soma_adat} class,
however a dispatch is in place to direct users to alternatives.
}
\examples{
# S3 print method
example_data

# show the header info (no RFU data)
print(example_data, show_header = TRUE)

# S3 summary method
# MMP analytes (4)
mmps <- c("seq.2579.17", "seq.2788.55", "seq.2789.26", "seq.4925.54")
mmp_adat <- example_data[, c("Sex", mmps)]
summary(mmp_adat)

# Summarize by group
mmp_adat |>
  split(mmp_adat$Sex) |>
  lapply(summary)

# Alternatively pass annotations with Target info
anno <- getAnalyteInfo(mmp_adat)
summary(mmp_adat, tbl = anno)
}
\seealso{
\code{\link[=groupGenerics]{groupGenerics()}}

Other IO: 
\code{\link{loadAdatsAsList}()},
\code{\link{parseHeader}()},
\code{\link{read_adat}()},
\code{\link{write_adat}()}
}
\concept{IO}
