% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getTaxonSMR.R
\name{getTaxonSMR}
\alias{getTaxonSMR}
\title{Lookup Pre-calculated Soil Moisture Regimes by Taxon}
\usage{
getTaxonSMR(
  taxon = NULL,
  code = NULL,
  as.is = FALSE,
  droplevels = FALSE,
  ordered = TRUE
)
}
\arguments{
\item{taxon}{\emph{character}. Vector of taxon names (order to subgroup level).
These values are converted to taxon "codes"}

\item{code}{\emph{character}. Vector of taxon codes.}

\item{as.is}{\emph{logical}. Return character labels rather than an (ordered)
factor? Default: \code{FALSE}}

\item{droplevels}{\emph{logical}. Drop unused levels? Default: \code{FALSE}}

\item{ordered}{\emph{logical}. Create an ordinal factor? Default: \code{TRUE}}
}
\value{
\emph{character} or \emph{factor} (when as.is=FALSE) containing soil moisture
regime labels extracted from 13th edition Keys to Soil Taxonomy taxa using
\code{extractSMR()}
}
\description{
Helper function for using  latest version of the Keys to Soil Taxonomy
standard lookup table for soil moisture information.
}
\examples{
getTaxonSMR(c("aridisols", "haploxeralfs", NA, "abruptic durixeralfs", "ustic haplocryalfs"))
}
\seealso{
\code{\link[=extractSMR]{extractSMR()}} \link{ST_SMR_13th}
}
