% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parLapplyW.R
\name{parLapplyW}
\alias{parLapplyW}
\title{A wrapper for parLapply}
\usage{
parLapplyW(X, FUN, ..., njobs = parallel::detectCores() - 1, expr = NULL,
  varlist = NULL, envir = parent.frame())
}
\arguments{
\item{X}{A vector (atomic or list)}

\item{FUN}{A function or character string naming a function whose first argument will be passed the elements of \code{X}}

\item{njobs}{The number of jobs (cores) to use}

\item{expr}{An expression that will be evaluated on each worker node via a call to \code{\link{clusterEvalQ}}}

\item{varlist}{Character vector of names of objects to export to each worker node via \code{\link{clusterExport}}}

\item{envir}{The environment containing the variables in \code{varlist} that will be exported}

\item{\dots}{Additional named arguments to \code{FUN}}
}
\value{
The same result given by \code{lapply(X, FUN, ...)}
}
\description{
A wrapper to make calls to \code{\link{parLapply}} easier by initializing the cluster, exporting objects and expressions to the
worker nodes, and shutting down the cluster.
}
\details{
The expression in \code{expr} is evaluated before the variables in \code{varlist} are exported.
}
\examples{
# Create a simple list
a <- list(a = rnorm(10), b = rnorm(20), c = rnorm(15))

# Some objects that will be needed by f1:
b1 <- rexp(20)
b2 <- rpois(10, 20)

# The function, which will depend on the Smisc package
f1 <- function(x, someText = "this.stuff") {
 textJunk <- stripExtension(someText)
 result <- mean(x) + max(b1) - min(b2)
 return(list(textJunk, result))
}

# Call parLapplyW(), loading the Smisc package and passing in the "b1" and "b2" objects
res.1 <- parLapplyW(a, f1, someText = "that.stuff", njobs = 2,
                   expr = expression(library(Smisc)),
                   varlist = c("b1", "b2"))

print(res.1)

# Call parLapplyW(), note that we're sending a different value for "b2" into the worker nodes
# via the 'expr' argument
res.2 <- parLapplyW(a, f1, someText = "that.stuff", njobs = 2,
                   expr = expression({library(Smisc); b2 <- rnorm(10)}),
                   varlist = c("b1"))

# These should not be equivalent
identical(res.1, res.2)

# Call lapply
res.3 <- lapply(a, f1, someText = "that.stuff")

# Compare results, these should be equivalent
identical(res.1, res.3)

}
\author{
Landon Sego
}
\seealso{
\code{\link{lapply}}, \code{\link{parLapply}}, \code{\link{plapply}}
}

