% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fn_exp_report.R
\name{ExpReport}
\alias{ExpReport}
\title{Function to create HTML EDA report}
\usage{
ExpReport(data,Template=NULL,Target=NULL,label=NULL,op_file=NULL,
op_dir=getwd(),sc=NULL,sn=NULL,Rc=NULL)
}
\arguments{
\item{data}{a data frame}

\item{Template}{R markdown template (.rmd file)}

\item{Target}{dependent variable. If there is no defined target variable then keep as it is NULL.}

\item{label}{target variable descriptions, not a mandatory field}

\item{op_file}{output file name (.html)}

\item{op_dir}{output path}

\item{sc}{sample number of plots for categorical variable. User can decide how many number of plots to depict in html report.}

\item{sn}{sample number of plots for numerical variable. User can decide how many number of plots to depict in html report.}

\item{Rc}{reference category of target variable. If Target is categorical then Pclass value is mandatory and which should not be NULL}
}
\description{
Create a exploratory data analysis report in HTML format
}
\details{
The "ExpReport" function will generate a HTML report for any R data frames.
If the markdown template is ready, we can use that template to generate the HTML report else
It will generate three different types of HTML report based on the Target field

IF Target = NULL, means there is no defined dependent varaible then it will genreate general EDA report at overall level

IF Target = continuous, then it will genreate EDA report including univariate and multivarite summary statistics with correlation.

IF Target = categorical, then it will genreate EDA report including univariate and multivarite summary statistics with chi-square, Information values.
}
\seealso{
\code{\link[DataExplorer:create_report]{create_report}}
}
