% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PLSroundingFits.R
\name{PLSroundingFits}
\alias{PLSroundingFits}
\title{Small count rounding with post-processing to expected frequencies}
\usage{
PLSroundingFits(
  data,
  freqVar = NULL,
  roundBase = 3,
  hierarchies = NULL,
  formula = NULL,
  dimVar = NULL,
  preAggregate = is.null(freqVar),
  xReturn = FALSE,
  extend0 = TRUE,
  limit = 1e-10,
  viaQR = FALSE,
  iter = 1000,
  eps = 0.01,
  tol = 1e-13,
  reduceBy0 = TRUE,
  reduceByColSums = TRUE,
  reduceByLeverage = FALSE,
  ...
)
}
\arguments{
\item{data}{data frame (inner cells)}

\item{freqVar}{Variable holding counts}

\item{roundBase}{Rounding base}

\item{hierarchies}{List of hierarchies}

\item{formula}{Model formula}

\item{dimVar}{Dimensional variables}

\item{preAggregate}{Aggregation}

\item{xReturn}{Dummy matrix in output when \code{TRUE}. To return crossTable as well, use \code{xReturn = 2}.}

\item{extend0}{Data is automatically extended by \code{Extend0} when \code{TRUE}. Can also be specified as a list meaning parameter \code{varGroups} to \code{Extend0}.}

\item{limit}{\code{LSfitNonNeg} parameter}

\item{viaQR}{\code{LSfitNonNeg} parameter}

\item{iter}{\code{Mipf} parameter}

\item{eps}{\code{Mipf} parameter}

\item{tol}{\code{Mipf} parameter}

\item{reduceBy0}{\code{Mipf} parameter}

\item{reduceByColSums}{\code{Mipf} parameter}

\item{reduceByLeverage}{\code{Mipf} parameter}

\item{...}{Further parameters to \code{\link{PLSrounding}}.}
}
\value{
Output from \code{\link{PLSrounding}} (class attribute "PLSrounded") with modified versions of \code{inner} and \code{publish}:
\item{inner}{Extended with more input data variables and with expected frequencies (\code{ipFit}).}
\item{publish}{Extended with aggregated expected frequencies (\code{ipFit}).}
}
\description{
The counts rounded by \code{\link{PLSrounding}}
Thereafter, based on the publishable rounded data, expected inner cell frequencies are generated by iterative proportional fitting using \code{\link[SSBtools]{Mipf}}.
To ensure that empty cells missing in input data are included in the fitting process, the data is first extended using \code{\link[SSBtools]{Extend0}}.
}
\details{
The seven first parameters is documented in more detail in \code{\link{PLSrounding}}.
If iterative proportional fitting succeeds, the maximum difference between rounded counts and \code{ipFit} is less than input parameter \code{eps}.
}
\examples{
z <- data.frame(geo  = c("Iceland", "Portugal", "Spain"), 
                eu = c("nonEU", "EU", "EU"),
                year = rep(c("2018","2019"), each = 3),
                freq = c(2,3,7,1,5,6), stringsAsFactors = FALSE)
z4 <- z[-c(1:2), ]

PLSroundingFits(z4, "freq", formula = ~eu * year + geo, extend0 = FALSE)[c("inner", "publish")]
PLSroundingFits(z4, "freq", formula = ~eu * year + geo)[c("inner", "publish")]

my_km2 <- SSBtools::SSBtoolsData("my_km2")

# Default automatic extension (extend0 = TRUE)
PLSroundingFits(my_km2, "freq", 
       formula = ~(Sex + Age) * Municipality * Square1000m + Square250m)[c("inner", "publish")]

# Manual specification to avoid Nittedal combined with another_km
PLSroundingFits(my_km2, "freq", formula = ~(Sex + Age) * Municipality * Square1000m + Square250m, 
       extend0 = list(c("Sex", "Age"), 
       c("Municipality", "Square1000m", "Square250m")))[c("inner", "publish")]
}
