% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SmCCNetSource.R
\name{getAbar}
\alias{getAbar}
\title{Compute the similarity matrix based on one or more canonical correlation 
weight vectors.}
\usage{
getAbar(Ws, P1 = NULL, FeatureLabel = NULL)
}
\arguments{
\item{Ws}{A canonical correlation weight vector or matrix. If \code{Ws} is a
matrix, then each column corresponds to one weight vector.}

\item{P1}{Total number of features for the first omics data type.}

\item{FeatureLabel}{If \code{FeatureLabel = NULL} (default), the feature 
names will be \eqn{\{TypeI_1, \cdots, TypeI_{p_1}, TypeII_1, \cdots, TypeII_{p-p_1}\}}, 
where \eqn{p_1 = }\code{P1}, and \eqn{p} is the total number of omics features.}
}
\value{
A \eqn{p\times p} symmetric non-negative matrix.
}
\description{
Compute the similarity matrix based on the outer products of absolute 
canonical correlation weights.
}
\examples{
w <- matrix(rnorm(6), nrow = 3)
Ws <- apply(w, 2, function(x)return(x/sqrt(sum(x^2))))
abar <- getAbar(Ws, P1 = 2, FeatureLabel = NULL)

}
