% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{ss.data.thickness}
\alias{ss.data.thickness}
\title{Metal Plates Thickness}
\format{A data frame with 24 observations on the following 5 variables.
\describe{ \item{thickness}{a numeric vector with the thickness
(\emph{in})} \item{day}{a factor with the day (two days)}
\item{shift}{a factor with the shift (two shifts)}
\item{dayshift}{a factor with the day-shift combination}
\item{position}{a factor with the position of the thickness with
respect to the nominal value of 0.75 \emph{in}} }}
\source{
Table 5.1 in the reference below.
}
\usage{
data("ss.data.thickness")
}
\description{
This data set contains the thickness and additional data for 24 metal
plates.
}
\details{
This data set illustrates concepts in the book ``Quality Control with R''.
Note that, in the book, the data set is named \code{plates} and it is
created sequentially throughout the examples.
}
\examples{

data(ss.data.thickness)
str(ss.data.thickness) 
lattice::bwplot(thickness ~ shift | day,
    data = ss.data.thickness)

}
\references{
Cano, E.L. and Moguerza, J.M. and Prieto Corcoba, M. (2015)
\emph{Quality Control with R. An ISO Standards Approach}. Springer.
}
\keyword{datasets}

