% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print_site_visits.R
\name{print_site_visits}
\alias{print_site_visits}
\title{Prints the site visitation results}
\usage{
print_site_visits(Name, X, Y, R, first = 'n', number_sites = -1, save = 'n')
}
\arguments{
\item{Name}{name of the data, which is used for any saved files and plot titles}

\item{X}{array of the x-coordinates describing the trajectory}

\item{Y}{array of the y-coordinates describing the trajectory}

\item{R}{radius value to use}

\item{first}{if \code{'y'}, the algorithm will look for the second greatest maximum percent drop if the first results in the first circle being the only non-identified site}

\item{number_sites}{number of sites to manually show the results for}

\item{save}{if \code{'y'}, the results will be saved as a csv file}
}
\value{
A summary table of the sites visited.
}
\description{
Prints a summary of the site positions and the time spent at and in between each site.
}
\details{
A summary is printed including the position of the site centres in the order that they are visited. The time spent at each site for each visit is also included as well as the time spent in between sites. There is also the option of saving the data in a csv file, with the title `\emph{Name}'_visits_R`\emph{R}'.csv.
}
\examples{
\donttest{##Find the current working directory
wd = getwd()
##Set the working directory as the temporary one
setwd(tempdir())
##Load the data
data(OU_14)
t=unlist(OU_14["t"])
X=unlist(OU_14["X"])
Y=unlist(OU_14["Y"])

##Calculate the residence time with a radius of 0.3 and not including the first circle
Alt_Alg("OU_14",t,X,Y,0.3,first='y',save='y')

##Prints a summary of the site visitation results
print_site_visits("OU_14",X,Y,0.3,first='y')

##There is also the option of saving the results as a csv file
print_site_visits("OU_14",X,Y,0.3,first='y',save='y')

##Reset the original working directory
setwd(wd)}
}
\references{
Munden, R., Borger , L., Wilson, R.P., Redcliffe, J., Loison, A., Garel, M. and Potts, J.P. in review. Making sense of ultra-high-resolution movement data: an algorithm for inferring sites of interest.
}
\seealso{
See also \code{\link{Alt_Alg}} to find the residence times. \code{\link{Sites}} can be used to find the coordinates of the centres of the sites and non-overlapping circles from the csv files produced by \code{\link{Alt_Alg}}. Then \code{\link{plot.schematic}} gives a visual representation of the order of sites visited.
}
\author{
Rhys Munden <rdmunden1@sheffield.ac.uk>
}
\keyword{Printed_summary}
