% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SNVdata_methods.R
\name{load_1KG}
\alias{load_1KG}
\title{Load pre-formatted 1000 Genomes Project exon data}
\usage{
load_1KG(chrom, pathway_df = NULL)
}
\arguments{
\item{chrom}{Numeric.  The chromosome number(s).  A numeric list of chromosome numbers representing the 1000 Genomes Project exon-data to load.}

\item{pathway_df}{Data frame. (Optional) A data frame that contains the positions for each exon in a pathway of interest.  This data frame must contain the variables \code{chrom}, \code{exonStart}, and \code{exonEnd}. See Details.}
}
\value{
An object of class \code{SNVdata} containing the imported exon data.
}
\description{
Load pre-formatted 1000 Genomes Project exon data
}
\details{
The \code{load_1KG} is used to load pre-formatted, exon-only SNV data from any of the 22 human autosomes.  The original data was obtained from:

http://ftp.1000genomes.ebi.ac.uk/vol1/ftp/data_collections/1000_genomes_project/release/.

The data was reduced to remove any related indiviuals, to accopmlish this we randomly sampled one relative from each set of related individuals.  This resulted in the removal of 22 individuals.  Additional information regaring the formatting of the 1000 Genomes Project data may be found at https://github.com/simrvprojects/1000-Genomes-Exon-Data/ in the pdf file entitled "Documentation for Creating Exon Data_090319.pdf".

We expect that \code{pathwayDF} does not contain any overlapping segments.  Users may combine overlapping exons into a single observation with the \code{\link{combine_exons}} function.
}
\examples{
exdata = load_1KG(21:22)
unique(exdata$Mutations$chrom)

head(exdata$Mutations)
exdata$Haplotypes[1:20, 1:10]
head(exdata$Samples)
}
\references{
1000 Genomes Project (2010). \emph{A Map of Human Genome Variation from Population-Scale Sequencing}. Nature; 467:1061-1073.
}
\seealso{
\code{\link{combine_exons}}
}
