% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/merge_additional_sims.R
\name{upsert_merge}
\alias{upsert_merge}
\alias{merge_additional_results}
\title{Merge results from additional or updated simulations}
\usage{
upsert_merge(x, y, by)

merge_additional_results(
  old,
  new,
  design_names = NULL,
  descriptive_regex = NULL
)
}
\arguments{
\item{x}{left data.frame}

\item{y}{right data.frame}

\item{by}{columns to match by}

\item{old}{old results}

\item{new}{new/additional results}

\item{design_names}{names of the paramterst}

\item{descriptive_regex}{regular expression for columns of descriptive statistics}
}
\value{
a data.frame

a data.frame of the merged simulation results
}
\description{
Merge results from additional or updated simulations
}
\details{
updates columns in x with values from matched rows in y and add
joins columns from y not present in x. Calls \code{rows_upsert} and then
\code{full_join}.

if \code{design_names} is omitted its value is taken from the
\code{design_names} attribute of the simulation results.

If \code{descriptive_regex} is given, columns matching the regular expression in
both datasets are compared, a warning is given, if the values of those
columns do not match. This is intended to compare descriptive statistics or
results of unchanged analysis methods to ensure, that both results stem
from an exact replication of the simulation results.
}
\section{Functions}{
\itemize{
\item \code{upsert_merge()}: Update or add Rows and Columns

}}
\examples{
a <- data.frame(x=5:2, y=5:2, a=5:2)
b <- data.frame(x=1:4, y=1:4+10, b=1:4*10)
upsert_merge(a, b, by="x")
\donttest{
condition <- merge(
  assumptions_delayed_effect(),
  design_fixed_followup(),
  by=NULL
) |>
  tail(4) |>
  true_summary_statistics_delayed_effect(cutoff_stats = 15)

condition_1 <- condition[1:2, ]
condition_2 <- condition[3:4, ]

# runs simulations
sim_results_1 <- runSimulation(
  design=condition_1,
  replications=100,
  generate=generate_delayed_effect,
  analyse=list(
    logrank  = analyse_logrank(alternative = "one.sided"),
    maxcombo = analyse_logrank(alternative = "one.sided")
  ),
  summarise = create_summarise_function(
    logrank = summarise_test(0.025),
    maxcombo = summarise_test(0.025)
  )
)

sim_results_2 <- runSimulation(
  design=condition_2,
  replications=100,
  generate=generate_delayed_effect,
  analyse=list(
    logrank  = analyse_logrank(alternative = "one.sided"),
    maxcombo = analyse_logrank(alternative = "one.sided")
  ),
  summarise = create_summarise_function(
    logrank = summarise_test(0.025),
    maxcombo = summarise_test(0.025)
  )
)

sim_results_3 <- runSimulation(
  design=condition,
  replications=100,
  generate=generate_delayed_effect,
  analyse=list(
    mwlrt = analyse_modelstly_weighted(t_star = m2d(24))
  ),
  summarise = create_summarise_function(
    mwlrt = summarise_test(0.025)
  )
)

all_results <- sim_results_1 |>
  merge_additional_results(sim_results_2) |>
  merge_additional_results(sim_results_3)

all_results |>
  subset(select=c(delay, logrank.rejection_0.025, maxcombo.rejection_0.025, mwlrt.rejection_0.025))

}
}
