% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/n.R
\name{n_replicates}
\alias{n_replicates}
\alias{n_replicates,SimInf_model-method}
\title{Determine the number of replicates in a model}
\usage{
n_replicates(model)

\S4method{n_replicates}{SimInf_model}(model)
}
\arguments{
\item{model}{the \code{model} object to extract the number of
replicates from.}
}
\value{
the number of replicates in the model.
}
\description{
Determine the number of replicates in a model
}
\examples{
## Create an 'SIR' model with 100 nodes, with 99 susceptible,
## 1 infected and 0 recovered in each node.
u0 <- data.frame(S = rep(99, 100), I = rep(1, 100), R = rep(0, 100))
model <- SIR(u0 = u0, tspan = 1:10, beta = 0.16, gamma = 0.077)

## Display the number of replicates in the model.
n_replicates(model)
}
