\name{summary.hapQuant}
\alias{summary.hapQuant}
\alias{print.summary.hapQuant}

%- Also NEED an '\alias' for EACH other topic documented here.
\title{Summarize quantitative haplotype analysis models}
\description{
  Summary method for objects of class \code{hapQuant}
}
\usage{
\method{summary}{hapQuant}(object, ...)
\method{print}{summary.hapQuant}(x, digits = max(3, getOption("digits") - 3), 
	signif.stars = getOption("show.signif.stars"), ...)

}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{object}{object of class \code{hapQuant}, the result of a call to \code{haplo.quant}.}
  \item{x}{an object of class \code{summary.hapQuant}, the result of a call to \preformatted{summary.hapQuant.}}
  \item{digits}{the number of significant digits to use when printing.}
  \item{signif.stars}{logical. If \code{TRUE}, ``significance stars" are printed for each coefficient.}
  \item{\dots}{further arguments passed to or from other methods.}
  
}

\value{
  \code{summary.hapQuant} returns an object of class \code{summary.hapQuant}, a list with components
     
  \item{formula}{\code{formula1} passed into \code{haplo.quant}.}
  \item{coefficients}{a table containing the coefficients, standard errors and p-values of the parameter estimates.}
  \item{empiricalResults}{a list containing the coefficients, standard errors and p-values calculated at each simulation of \code{haplo.quant}.}
  \item{rsquared}{r-squared values for the model including haplotypes and the model excluding haplotypes.}
  \item{LRT}{a likelihood ratio test, testing for significant improvement of the model when haplotypic parameters are included.}
  \item{AIC}{Akaike Information Criterion for the linear model fit including haplotypes.}
  \item{predicted}{estimated marginal means of the outcome variable broken down by haplotype levels, evaluated at mean values of the model predictors, averaged over all simulations.}
  \item{effect}{the haplotypic effect modelled: `ADDITIVE', `DOMINANT' or `RECESSIVE'.}

}
\references{
McCaskie, P.A., Carter, K.W. Hazelton, M., Palmer, L.J. (2007) SimHap: A comprehensive modeling framework for epidemiological outcomes and a multiple-imputation approach to haplotypic analysis of population-based data, [online] www.genepi.org.au/simhap.
}
\author{Pamela A. McCaskie}

\seealso{\code{\link{haplo.quant}}}
\examples{

data(SNP.dat)

# convert SNP.dat to format required by infer.haplos
haplo.dat <- SNP2Haplo(SNP.dat)

data(pheno.dat)

# generate haplotype frequencies and haplotype design matrix
myinfer<-infer.haplos(haplo.dat) 

# print haplotype frequencies generated by infer.haplos
myinfer$hap.freq 

# generate haplo object where haplotypes with a frequency 
# below min.freq are grouped as a category called "rare"
myhaplo<-make.haplo.rare(myinfer,min.freq=0.05) 
mymodel <- haplo.quant(formula1=HDL~AGE+SBP+h.N1AA, formula2=HDL~AGE+SBP, 
	pheno=pheno.dat, haplo=myhaplo, sim=10)
summary(mymodel)

}
% Add one or more standard keywords, see file 'KEYWORDS' in the
% R documentation directory.
\keyword{methods}
