% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coef_rep.R
\name{coef_rep}
\alias{coef_rep}
\title{Response coefficient computation}
\usage{
coef_rep(E_fun,A_fun,correl_fun,beta_fun=NULL)
}
\arguments{
\item{E_fun}{Numeric vector of concentrations}

\item{A_fun}{Numeric vector of activities}

\item{correl_fun}{Character string indicating the abbreviation of the constraint applied on the system}

\item{beta_fun}{Matrix of co-regulation coefficients}
}
\value{
Numeric vector of the response coefficients of each enzyme
}
\description{
Computes the response coefficients for each enzyme
}
\details{
The response coefficients are influenced by the applied constraint.

Response coefficients are an extension of the control coefficients defined in the Metabolic Control Theory (Kacser and Burns, 1973).
For further details on how the response coefficient is calculated, see Lion \emph{et al.} (2004).

\code{A_fun} and \code{E_fun} need to have the same length.
The restrictions on \code{beta_fun} are explained in \code{\link{alpha_ij}}.
}
\examples{
A <- c(1,10,30)
E <- c(30,30,30)
beta <- matrix(c(1,10,5,0.1,1,0.5,0.2,2,1),nrow=3)
correl <- "SC"

response <- coef_rep(E,A,correl,beta)


# result : response = c(0.88235294, 0.08823529, 0.02941176)

}
\references{
Lion, S., F. Gabriel, B. Bost, J. Fiévet, C. Dillmann, and D. De Vienne, 2004.
An extension to the metabolic control theory taking into account correlations between enzyme concentrations.
European Journal of Biochemistry 271:4375–4391.
}
\seealso{
Use function \code{\link{activities}} to compute enzyme activities.
}
