% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compute.delta.R
\name{compute.delta}
\alias{compute.delta}
\title{Computation of mutation actual effect}
\usage{
compute.delta(nu_fun,E_fun,correl_fun,B_fun=NULL)
}
\arguments{
\item{nu_fun}{Numeric. Canonical effect of the mutation}

\item{E_fun}{Numeric vector of concentrations}

\item{correl_fun}{Character string indicating the abbreviation of the constraint applied on the system}

\item{B_fun}{Numeric vector of global co-regulation coefficients}
}
\value{
Numeric vector. Each element \code{i} of the vector is the actual effect \eqn{\delta_i} for which enzyme \code{i} in \code{E_fun} is targeted by the mutation.
}
\description{
Computes the actual effect \eqn{\delta} of a mutation
}
\details{
Computes the actual effect \eqn{\delta} of a mutation depending on its canonical effect \eqn{\nu} and on the constraints.
}
\examples{
mu <- 1
E <- c(30,30,30)
beta <- matrix(c(1,10,5,0.1,1,0.5,0.2,2,1),nrow=3)
B <- apply(beta,1,sumbis)
correl <- "RegPos"

compute.delta(mu,E,correl,B)


}
\seealso{
Use function \code{\link{is.correl.authorized}} to see allowed constraints for \code{correl_fun}.
}
