% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/update_sim.R
\name{update_sim}
\alias{update_sim}
\title{Update a simulation}
\usage{
update_sim(sim, keep_errors = T)
}
\arguments{
\item{sim}{A simulation object of class \code{sim_obj}, usually created by
\code{\link{new_sim}}, that has already been run by the \code{\link{run}}
function}

\item{keep_errors}{logical (\code{TRUE} by default); if \code{TRUE}, do not
try to re-run simulation reps that results in errors previously; if
\code{FALSE}, attempt to run those reps again}
}
\value{
The original simulation object with additional simulation replicates
    in \code{results} or \code{errors}
}
\description{
This function updates a previously run simulation. After a
   simulation has been \code{\link{run}}, you can alter the levels of the
   resulting object of class \code{sim_obj} using \code{\link{set_levels}},
   or change the configuration (including the number of simulation
   replicates) using \code{\link{set_config}}. Executing \code{update_sim} on
   this simulation object will only run the added levels/replicates, without
   repeating anything that has already been run.
}
\details{
\itemize{
  \item{It is not possible to add new level variables, only new levels of the
  existing variables. Because of this, it is best practice to include all
  potential level variables before initially running a simulation, even if
  some of them only contain a single level. This way, additional levels can
  be added later.}
}
}
\examples{
sim <- new_sim()
create_data <- function(n) { rpois(n, lambda=5) }
est_mean <- function(dat, type) {
  if (type=="M") { return(mean(dat)) }
  if (type=="V") { return(var(dat)) }
}
sim \%<>\% set_levels(n=c(10,100), est="M")
sim \%<>\% set_config(num_sim=10)
sim \%<>\% set_script(function() {
  dat <- create_data(L$n)
  lambda_hat <- est_mean(dat=dat, type=L$est)
  return (list("lambda_hat"=lambda_hat))
})
sim \%<>\% run()
sim \%<>\% set_levels(n=c(10,100,1000), est=c("M","V"))
sim \%<>\% set_config(num_sim=5)
sim \%<>\% update_sim()
}
