% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/links.R
\name{LinkPeaks}
\alias{LinkPeaks}
\title{Link peaks to genes}
\usage{
LinkPeaks(
  object,
  peak.assay,
  expression.assay,
  expression.slot = "data",
  gene.coords = NULL,
  distance = 5e+05,
  min.cells = 10,
  method = "pearson",
  genes.use = NULL,
  n_sample = 200,
  pvalue_cutoff = 0.05,
  score_cutoff = 0.05,
  verbose = TRUE
)
}
\arguments{
\item{object}{A Seurat object}

\item{peak.assay}{Name of assay containing peak information}

\item{expression.assay}{Name of assay containing gene expression information}

\item{expression.slot}{Name of slot to pull expression data from}

\item{gene.coords}{GRanges object containing coordinates of genes in the
expression assay. If NULL, extract from gene annotations stored in the assay.}

\item{distance}{Distance threshold for peaks to include in regression model}

\item{min.cells}{Minimum number of cells positive for the peak and gene
needed to include in the results.}

\item{method}{Which correlation coefficient to compute. Can be "pearson"
(default), "spearman", or "kendall".}

\item{genes.use}{Genes to test. If NULL, determine from expression assay.}

\item{n_sample}{Number of peaks to sample at random when computing the null
distribution.}

\item{pvalue_cutoff}{Minimum p-value required to retain a link. Links with a
p-value equal or greater than this value will be removed from the output.}

\item{score_cutoff}{Minimum absolute value correlation coefficient for a link
to be retained}

\item{verbose}{Display messages}
}
\value{
Returns a Seurat object with the \code{Links} information set, with
each recorded link being the correlation coefficient between the
accessibility of the peak and expression of the gene.
}
\description{
Find peaks that are correlated with the expression of nearby genes.
For each gene, this function computes the correlation coefficient between
the gene expression and accessibility of each peak within a given distance
from the gene TSS, and computes an expected correlation coefficient for each
peak given the GC content, accessibility, and length of the peak. The expected
coefficent values for the peak are then used to compute a z-score and p-value.
}
\details{
This function was inspired by the method originally described by SHARE-seq
(Sai Ma et al. 2020, Cell). Please consider citing the original SHARE-seq
work if using this function: \url{https://doi.org/10.1016/j.cell.2020.09.056}
}
\concept{links}
