% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/make.functions.R
\name{make.linear.decay}
\alias{make.linear.decay}
\title{Make a linear decay function}
\usage{
make.linear.decay(threshold)
}
\arguments{
\item{threshold}{A numeric representing how quickly the hybridization success decays. Smaller values denote a quicker decay}
}
\value{
A linear decay function
}
\description{
Create a linear decay function for genetic distance of two taxa and the probability of success of a hybridization event
}
\details{
The function computes: \deqn{1-\frac{d}{t} }{1-(d/t)}
where d is the genetic distance between taxa
}
\note{
a distance \eqn{d} greater than \eqn{t} will return 0
}
\examples{
set.seed(17)
dist_func<- make.linear.decay(0.5)
net<-sim.bdh.age(1,1,5,2,2,c(1/3,1/3,1/3),hyb.inher.fxn = make.uniform.draw(),
hyb.rate.fxn=dist_func,complete=TRUE)[[1]]
}
