#' Homeostasis concept inventory pretest and posttest scores
#'
#' @description `HCIprepost` dataset consists of the pretest and
#'   posttest score of 16 students to Homeostasis Concept Inventory (HCI).
#'   Between the pre-test and post-test, the students received
#'   instruction on homeostasis within a physiology course.
#'
#' @author Jenny L. McFarland \cr Biology Department, Edmonds Community College
#'
#' @references McFarland, J. L., Price, R. M., Wenderoth, M. P., Martinkova, P.,
#'   Cliff, W., Michael, J., ... & Wright, A. (2017). Development and validation
#'   of the homeostasis concept inventory. CBE-Life Sciences Education, 16(2),
#'   ar35. \doi{10.1187/cbe.16-10-0305}
#'
#' @keywords datasets
#'
#' @seealso
#' [HCI] for HCI dichotomous dataset\cr
#' [HCItest] for HCI multiple-choice dataset\cr
#' [HCIkey] for key of correct answers for HCI\cr
#' [HCIdata] for HCI full dataset\cr
#' [HCIlong] for HCI in a long format\cr
#' [HCIgrads]  for HCI dataset of graduate students\cr
#' [HCItestretest] for HCI test-retest dataset\cr
#'
#' @format `HCIprepost` is a `data.frame` consisting of 16
#'   observations on the 2 variables.
#'   \describe{
#'   \item{id}{Anonymized respondent ID. }
#'   \item{score.pre}{Pretest score. } \item{score.post}{Posttest score. }
#'   }
"HCIprepost"
