% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/blis.R
\name{nominal_to_int}
\alias{nominal_to_int}
\title{Turn nominal (factor) data to integers, keep original levels with a key of
correct responses alongside}
\usage{
nominal_to_int(Data, key)
}
\arguments{
\item{Data}{\emph{data.frame} or \emph{tibble} with all columns being factors. Support
for \emph{matrix} is limited and behavior not guaranteed.}

\item{key}{A single-column \code{data.frame}, (\strong{not} matrix) \code{tibble} or -
preferably - a factor vector of levels considered as correct responses.}
}
\value{
\emph{List} of original levels with logical attribute \code{key}, which stores
the information on which response (level) is considered  correct. \emph{Note
that levels not used in the original data are dropped.}
}
\description{
Convert a \code{data.frame} or \code{tibble} with factor variables (items) to integers,
keeping the original factor levels (i.e. response categories) and correct
answers (stored as an \code{key} attribute of each item) alongside.
}
\details{
Fitting a nominal model using \code{\link[mirt:mirt]{mirt::mirt()}} package requires the dataset to
consist only of integers, \emph{arbitrarily} representing the response categories.
You can convert your dataset to integers on your own in that case.

On the other hand, BLIS model (and thus also the BLIRT parametrization)
further requires the information of correct item response category. On top of
that, the same information is leveraged when fitting a \code{mirt} model that
conserves the "directionality" of estimated latent ability (using a model
definition from \code{\link[=obtain_nrm_def]{obtain_nrm_def()}}). In these cases, you are recommended to
use \code{\link[=nominal_to_int]{nominal_to_int()}} (note that \code{\link[=fit_blis]{fit_blis()}} and \code{\link[=blis]{blis()}} does this
internally). Note also that fitted BLIS model (of class \linkS4class{BlisClass}) stores
the original levels with correct answer key in its \code{orig_levels} slot,
accessible by a user via \code{\link[=get_orig_levels]{get_orig_levels()}}.
}
\seealso{
Other BLIS/BLIRT related: 
\code{\link{BlisClass-class}},
\code{\link{coef,BlisClass-method}},
\code{\link{fit_blis}()},
\code{\link{get_orig_levels}()},
\code{\link{obtain_nrm_def}()},
\code{\link{print.blis_coefs}()}
}
\concept{BLIS/BLIRT related}
