% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggWrightMap.R
\name{ggWrightMap}
\alias{ggWrightMap}
\title{Plot Wright map using ggplot}
\usage{
ggWrightMap(
  theta,
  b,
  binwidth = 0.5,
  color = "blue",
  size = 15,
  item.names,
  ylab.theta = "Respondent latent trait",
  ylab.b = "Item difficulty",
  ...
)
}
\arguments{
\item{theta}{numeric: vector of ability estimates.}

\item{b}{numeric: vector of difficulty estimates.}

\item{binwidth}{numeric: the width of the bins of histogram.}

\item{color}{character: color of histogram.}

\item{size}{text size in pts.}

\item{item.names}{names of items to be displayed.}

\item{ylab.theta}{character: description of y-axis for the histogram.}

\item{ylab.b}{character: description of y-axis for the plot of difficulty
estimates.}

\item{...}{
  Arguments passed on to \code{\link[cowplot:plot_grid]{cowplot::plot_grid}}
  \describe{
    \item{\code{rel_widths}}{(optional) Numerical vector of relative columns widths. For example, in a two-column
grid, \code{rel_widths = c(2, 1)} would make the first column twice as wide as the
second column.}
  }}
}
\description{
This function allows to generate Wright map (also called
  item-person map) using \code{ggplot()} function from the \pkg{ggplot2}
  package and \code{plot_grid()} function from the \pkg{cowplot} package.
  Wright map is used to display histogram of factor scores and the item
  difficulty parameters estimated by the Rasch IRT model.
}
\examples{
library(mirt)

data(HCI)

# fit Rasch model with the mirt package
fit <- mirt(HCI[, 1:20], model = 1, itemtype = "Rasch")
# factor scores
theta <- as.vector(fscores(fit))
# difficulty estimates using IRT parametrization
b <- coef(fit, simplify = TRUE, IRTpars = TRUE)$items[, "b"]

# Wright map
ggWrightMap(theta, b)

# Wright map with modified item names
item.names <- paste("Item", 1:20)
ggWrightMap(theta, b, item.names = item.names)

# Wright map with modified descriptions of y-axis and relative widths of plots
ggWrightMap(theta, b,
  ylab.theta = "Latent trait", ylab.b = "Difficulty estimates",
  rel_widths = c(2, 1)
)
}
\references{
Wright, B. & Stone, M. (1979). Best test design. MESA Press: Chicago, IL
}
\author{
Adela Hladka \cr
Institute of Computer Science of the Czech Academy of Sciences \cr
Faculty of Mathematics and Physics, Charles University \cr
\email{hladka@cs.cas.cz} \cr

Patricia Martinkova \cr
Institute of Computer Science of the Czech Academy of Sciences \cr
\email{martinkova@cs.cas.cz} \cr
}
