% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotDistractorAnalysis.R
\name{plotDistractorAnalysis}
\alias{plotDistractorAnalysis}
\title{Function for graphical representation of item distractor analysis}
\usage{
plotDistractorAnalysis(data, key, num.groups = 3, item = 1, multiple.answers = TRUE)
}
\arguments{
\item{data}{character: data matrix or data frame. See \strong{Details}.}

\item{key}{character: answer key for the items.}

\item{num.groups}{numeric: number of groups to that should be respondents splitted.}

\item{item}{numeric: the number of item to be plotted.}

\item{multiple.answers}{logical: should be all combinations plotted (default) or should be
answers splitted into distractors. See \strong{Details}.}
}
\description{
Plots graphical representation of item distractor analysis with proportions and
optional number of groups.
}
\details{
This function is graphical representation of \code{DistractorAnalysis} function.
The scores are calculatede using the item data and key. The respondents are then splitted into
the \code{num.groups}-quantiles and the proportion of respondents in each quantile is
reported with respect to their answers, using all reported combinations (default) or distractors.
These proportions are plotted.

The \code{data} is a matrix or data frame whose rows represents unscored item response from a
multiple-choice test and columns correspond to the items.

The \code{key} must be a vector of the same length as \code{ncol(data)}.

If \code{multiple.answers = TRUE} (default) all reported combinations of answers are plotted.
If \code{multiple.answers = FALSE} all combinations are splitted into distractors and only these
are then plotted with correct combination.
}
\examples{
\dontrun{
# loading difMedicaltest data set
data(difMedicaltest, package = "difNLR")
data  <- difMedicaltest[, colnames(difMedicaltest) != "gender"]
# loading difMedicalkey
data(difMedicalkey, package = "difNLR")
key  <- difMedicalkey

# distractor analysis plot for item 1, all combinations
plotDistractorAnalysis(data, key, item = 1)

# distractor analysis plot for item 1, distractors
plotDistractorAnalysis(data, key, item = 1, multiple.answers = F)

# distractor analysis plot for item 3, all combinations and 6 groups
plotDistractorAnalysis(data, key, num.group = 6, item = 3)

}


}
\author{
Adela Drabinova \cr
Institute of Computer Science, The Czech Academy of Sciences \cr
Faculty of Mathematics and Physics, Charles University \cr
adela.drabinova@gmail.com \cr

Patricia Martinkova \cr
Institute of Computer Science, The Czech Academy of Sciences \cr
martinkova@cs.cas.cz \cr
}

